package ips.media.player;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;

import javax.swing.JFrame;

import ips.media.MediaDecodingPlayer;
import ips.media.NativeMediaSystemException;
import ips.media.NativeMediaSystemsManager;
import ips.media.control.MediaControlListener;
import ips.media.io.StreamSource;
import ips.media.spi.NativeMediaSystem;
import ips.media.ui.JPlayerControl;
import ips.media.video.AWTVideoComponent;
import ips.media.video.JVideoComponent;
import ips.media.video.VideoTrackListener;

public class MediaPlayer {

    private static boolean USE_SWING=false;
	private MediaDecodingPlayer mediaDecodingPlayer;
	public MediaDecodingPlayer getMediaDecodingPlayer() {
		return mediaDecodingPlayer;
	}

	public void setMediaDecodingPlayer(MediaDecodingPlayer mediaDecodingPlayer) {
		this.mediaDecodingPlayer = mediaDecodingPlayer;
	}

	public void addMediaControlListener(
			MediaControlListener mediaControlListener) {
		mediaDecodingPlayer.addMediaControlListener(mediaControlListener);
	}

	public void removeMediaControlListener(
			MediaControlListener mediaControlListener) {
		mediaDecodingPlayer.removeMediaControlListener(mediaControlListener);
	}

	public void addVideoTrackListener(VideoTrackListener videoTrackListener) {
		mediaDecodingPlayer.addVideoTrackListener(videoTrackListener);
	}

	public void open() throws NativeMediaSystemException {
		mediaDecodingPlayer.open();
	}

	public void start() {
		mediaDecodingPlayer.start();
	}

	public void pause() {
		mediaDecodingPlayer.pause();
	}

	public void stop() {
		mediaDecodingPlayer.stop();
	}

	public void close() {
		mediaDecodingPlayer.close();
	}

	public StreamSource getMediaStreamSource() {
		return mediaDecodingPlayer.getMediaStreamSource();
	}

	public void setMediaStreamSource(StreamSource mediaStreamSource) {
		mediaDecodingPlayer.setMediaStreamSource(mediaStreamSource);
	}

	public void setNativeMediaFile(File mediaFile) {
		mediaDecodingPlayer.setNativeMediaFile(mediaFile);
	}

	public void rewind() {
		mediaDecodingPlayer.rewind();
	}

//	public void stepForward() {
//		mediaDecodingPlayer.stepForward();
//	}

	public MediaPlayer(){
		super();	
	}
	
	public void init() throws NativeMediaSystemException{
		NativeMediaSystem nms=NativeMediaSystemsManager.createDefaultNativeMediaSystem();
		if(nms==null){
			System.err.println("Could not instantiate native media system.");
			System.exit(-1);
		}
		System.out.println("Using native media system: "+nms.getTitle().localize());
		mediaDecodingPlayer=nms.createMediaDecodingPlayer();
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		File mediaFile=new File(args[0]);
		
		final MediaPlayer p=new MediaPlayer();
		try {
			p.init();
		} catch (NativeMediaSystemException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		p.setNativeMediaFile(mediaFile);
		final Component vc;
		VideoTrackListener vtl;
		if(USE_SWING){
		    JVideoComponent jvc=new JVideoComponent();
//		    jvc.setScaleToComponent(false);
		    vc=jvc;
		    vtl=jvc;
		}else{
		    AWTVideoComponent awtVc=new AWTVideoComponent();
		    vc=awtVc;
		    vtl=awtVc;
		}
		
		p.addVideoTrackListener(vtl);
		vc.setPreferredSize(new Dimension(500,500));
		JFrame f=new JFrame();
		
		f.getContentPane().setLayout(new BorderLayout());
		
		f.getContentPane().add(vc,BorderLayout.CENTER);
		
		JPlayerControl pc=new JPlayerControl(p.getMediaDecodingPlayer());
		f.getContentPane().add(pc,BorderLayout.SOUTH);
		f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		f.addWindowListener(new WindowListener() {
			
			public void windowOpened(WindowEvent e) {
				try {
					p.open();
				} catch (NativeMediaSystemException ex) {
					// TODO Auto-generated catch block
					ex.printStackTrace();
				}
				if(vc instanceof AWTVideoComponent){
		           // ((AWTVideoComponent)vc).createBufferStrategy(4);
//					p.start();
		        }
				if(vc instanceof JVideoComponent){
			         
			        }
				//p.start();
			}
			
			public void windowIconified(WindowEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			public void windowDeiconified(WindowEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			public void windowDeactivated(WindowEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			public void windowClosing(WindowEvent e) {
				p.close();
				System.out.println("Player closed");
			}
			
			public void windowClosed(WindowEvent e) {
				System.out.println("window closed. exiting ...");
				System.exit(0);
			}
			
			public void windowActivated(WindowEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		f.pack();
		f.setVisible(true);
		
//		File mediaFile=new File(args[0]);
////		dsmdp.setMediaStreamSource(new FileStreamSource(mediaFile));
//		dsmdp.setNativeMediaFile(mediaFile);
		
	}

}
