package ips.media.ui;

import ipsk.text.MediaTimeFormat;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Position;

import ips.media.FrameStepControl;
import ips.media.MediaDecodingPlayer;
import ips.media.SeekControl;
import ips.media.control.MediaControlListener;
import ips.media.event.MediaCloseEvent;
import ips.media.event.MediaDurationAvailableEvent;
import ips.media.event.MediaEndEvent;
import ips.media.event.MediaErrorEvent;
import ips.media.event.MediaEvent;
import ips.media.event.MediaOpenEvent;
import ips.media.event.MediaPausedEvent;
import ips.media.event.MediaStartedEvent;
import ips.media.event.MediaStoppedEvent;

public class JPlayerControl extends JPanel implements ActionListener, MediaControlListener, ChangeListener {

    private int DEFAULT_UPDATE_MS=100;
	private MediaDecodingPlayer mdp;
	private JButton startButton;
//	private JButton pauseButton;
	
//	private JButton stepBackwardButton;
	private JButton stopButton;
	private JButton stepForwardButton;
	private JButton rewindButton;
	private JLabel posLabel;
	private JLabel durationLabel;
	private JSlider posSlider;
	private boolean paused=false;
	private MediaTimeFormat mtf=new MediaTimeFormat();
	private Timer uiUpdateTimer=null;
	private volatile boolean sliderUpdate=false;
	private final static long SLIDER_VAL_DIVIDER=(long)1000000;
	
	public JPlayerControl(MediaDecodingPlayer mdp){
		super();
		GridBagLayout l=new GridBagLayout();
		setLayout(l);
		GridBagConstraints gbc=new GridBagConstraints();
		gbc.gridx=0;
		gbc.gridy=0;
		this.mdp=mdp;
		startButton=new JButton("Start");
		startButton.setEnabled(false);
		startButton.addActionListener(this);
		add(startButton,gbc);
//		pauseButton=new JButton("Pause");
//		pauseButton.setEnabled(false);
//		pauseButton.addActionListener(this);
//		add(pauseButton);
//		stepBackwardButton=new JButton("<");
//        stepBackwardButton.setEnabled(false);
//        stepBackwardButton.addActionListener(this);
//        add(stepBackwardButton);
		gbc.gridx++;
		stopButton=new JButton("Stop");
		stopButton.setEnabled(false);
		stopButton.addActionListener(this);
		add(stopButton,gbc);
		
		gbc.gridx++;
		stepForwardButton=new JButton(">");
        stepForwardButton.setEnabled(false);
        stepForwardButton.addActionListener(this);
        add(stepForwardButton,gbc);
        
        gbc.gridx++;
		rewindButton=new JButton("Rewind");
//		rewindButton.setEnabled(false);
		rewindButton.addActionListener(this);
		add(rewindButton,gbc);
		rewindButton.setEnabled(false);
		
		gbc.gridx++;
		posLabel=new JLabel();
		add(posLabel,gbc);
		
		gbc.gridx++;
		durationLabel=new JLabel();
		add(durationLabel,gbc);
		
		gbc.gridx=0;
		gbc.gridy++;
		gbc.gridwidth=6;
		gbc.weightx=2.0;
		gbc.fill=GridBagConstraints.HORIZONTAL;
		posSlider=new JSlider();
		posSlider.setValue(0);
		posSlider.setEnabled(false);
		posSlider.addChangeListener(this);
		add(posSlider,gbc);
		
		mdp.addMediaControlListener(this);
		uiUpdateTimer=new Timer(DEFAULT_UPDATE_MS, this);
		uiUpdateTimer.setRepeats(true);
	}
	public void actionPerformed(ActionEvent arg0) {
		Object src=arg0.getSource();
		if(src==uiUpdateTimer){
			long pos=mdp.getPositionNs();
			String posStr=mtf.format(pos);
			posLabel.setText(posStr);
			// do not "disturb" manual user adjusting
	        if (!posSlider.getValueIsAdjusting()) {
			 int sliderPos=(int)(pos/SLIDER_VAL_DIVIDER);
			 sliderUpdate=true;
			 posSlider.setValue(sliderPos);
			 sliderUpdate=false;
	        }
		}else if(src==startButton){
//			if(paused){
//				mdp.pause();
//			}else{
				mdp.start();
		}
//		}else if(src==pauseButton){
//			mdp.pause();
//		}
		else if(src==stepForwardButton){
		    if(mdp instanceof FrameStepControl){
                FrameStepControl fsc=(FrameStepControl)mdp;
                fsc.frameStep(1);
            }
//			mdp.stepForward();
		}
//		else if(src==stepBackwardButton){
//            if(mdp instanceof FrameStepControl){
//                FrameStepControl fsc=(FrameStepControl)mdp;
//                fsc.frameStep(-1);
//            }
////          mdp.stepForward();
//        }
		else if(src==stopButton){
			mdp.stop();
		}else if(src==rewindButton){
			mdp.rewind();
		}
	}
	public void update(MediaEvent mediaEvent) {
		if(mediaEvent instanceof MediaOpenEvent){
			startButton.setEnabled(true);
			rewindButton.setEnabled(true);
			stepForwardButton.setEnabled(false);
			uiUpdateTimer.start();
//			stepBackwardButton.setEnabled(false);
			mdp.stop();
		}else if(mediaEvent instanceof MediaDurationAvailableEvent){
            MediaDurationAvailableEvent mdae=(MediaDurationAvailableEvent)mediaEvent;
            long durNs=mdae.getDurationNs();
            String durMfStr=mtf.format(durNs);
            durationLabel.setText(durMfStr);
            int sliderMax=(int)(durNs/SLIDER_VAL_DIVIDER);
            //posSlider.setMinimum(0);
            int currMax=posSlider.getMaximum();
            if(currMax!=sliderMax){
                posSlider.setMaximum(sliderMax);
            }
		}else if(mediaEvent instanceof MediaPausedEvent){
			paused=true;
			startButton.setEnabled(true);
//			pauseButton.setEnabled(false);
			stepForwardButton.setEnabled(true);
			stopButton.setEnabled(true);
			if(mdp instanceof FrameStepControl){
			    stepForwardButton.setEnabled(true);
//			    stepBackwardButton.setEnabled(true);
			}
			if(mdp instanceof SeekControl){
                posSlider.setEnabled(true);
            }
		}else if(mediaEvent instanceof MediaStartedEvent){
			startButton.setEnabled(false);
//			pauseButton.setEnabled(true);
			stopButton.setEnabled(true);
			if(mdp instanceof SeekControl){
                posSlider.setEnabled(true);
            }
		}else if(mediaEvent instanceof MediaStoppedEvent){
			startButton.setEnabled(true);
//			pauseButton.setEnabled(false);
//			stepForwardButton.setEnabled(false);
			if(mdp instanceof FrameStepControl){
                stepForwardButton.setEnabled(true);
//                stepBackwardButton.setEnabled(true);
            }
			if(mdp instanceof SeekControl){
                posSlider.setEnabled(true);
            }
			stopButton.setEnabled(false);		
		}else if(mediaEvent instanceof MediaEndEvent){
			stepForwardButton.setEnabled(false);
			mdp.stop();
			mdp.rewind();
		}else if(mediaEvent instanceof MediaCloseEvent || mediaEvent instanceof MediaErrorEvent){
			startButton.setEnabled(false);
//			pauseButton.setEnabled(false);
			stepForwardButton.setEnabled(false);
			posSlider.setEnabled(false);
			stopButton.setEnabled(false);
			rewindButton.setEnabled(false);
			
			if(uiUpdateTimer!=null){
			    uiUpdateTimer.stop();
			  
			}
			String undefinedStr=mtf.format(null);
            durationLabel.setText(undefinedStr);
            posLabel.setText(undefinedStr);
		}
	}
    @Override
    public void stateChanged(ChangeEvent arg0) {
        arg0.getSource();
        if(!sliderUpdate && ! posSlider.getValueIsAdjusting()){
            int sliderVal=posSlider.getValue();
//            int sliderMax=posSlider.getMaximum();
            long sliderPosNs=(long)sliderVal*SLIDER_VAL_DIVIDER;
            if(mdp instanceof SeekControl){
                SeekControl sc=(SeekControl)mdp;
                //            System.out.println("Seek to: "+sliderVal+" "+sliderMax);
                sc.seek(sliderPosNs);
            }
        }
    }
}
