package ips.media.video;

import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;

import javax.swing.JComponent;

public class AWTVideoComponent extends Canvas implements VideoTrackListener{

	
	private volatile BufferedImage currentFrame;
	private VideoFormat videoFormat;
	private Object frameLock=new Object();
	private int imgWidth=0;
	private int imgHeight=0;
	
	
	private boolean scaleToComponent=true;
	private boolean keepAspectRatio=true;
//    private RenderingHints rh;
//    private BufferedImageOp scaleOp;
    
    private boolean bsInitialized=false;
	private long lastFrame;
	public boolean isKeepAspectRatio() {
		return keepAspectRatio;
	}

	public void setKeepAspectRatio(boolean keepAspectRatio) {
		this.keepAspectRatio = keepAspectRatio;
	}

	public boolean isScaleToComponent() {
		return scaleToComponent;
	}

	public void setScaleToComponent(boolean scaleToComponent) {
		this.scaleToComponent = scaleToComponent;
	}

	public AWTVideoComponent() {
		super();
		
//		rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
//        rh.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);

	}
	
//	public void paint(Graphics g){
//		Graphics2D 	g2=(Graphics2D)g;
////		synchronized (frameLock) {
//			
//			if(currentFrame!=null){
////				if(scaleOp!=null){
////					g2.drawImage(currentFrame, scaleOp, 0, 0);
//////					g2.drawImage(currentFrame,0,0,(int)scaleX*imgWidth,(int)scaleY*imgHeight,null);
////				}else{
////					g2.drawImage(currentFrame,0,0,imgWidth,imgHeight,this);
////					g.drawImage(currentFrame, 0, 0,this);
////				}
//			}	
////		}
//	}
//	 public void update(Graphics g) {
//		 
//	 }
////	     super.update(g);
////	     Graphics offgc;
////	     Image offscreen = null;
////	     Dimension d = getSize();
////
////	     // create the offscreen buffer and associated Graphics
////	     offscreen = createImage(d.width, d.height);
////	     offgc = offscreen.getGraphics();
////	     // clear the exposed area
////	     offgc.setColor(getBackground());
////	     offgc.fillRect(0, 0, d.width, d.height);
////	     offgc.setColor(getForeground());
////	     // do normal redraw
////	     paint(offgc);
////	     // transfer offscreen to window
////	     g.drawImage(offscreen, 0, 0, this);
//	     
//	     // the frame image is already offscreen
//	     g.drawImage(currentFrame, 0, 0,this);
//	     }
	 
	public void doLayout(){
		if(isDisplayable()){
			updateScaleFactor();
			if(!bsInitialized){
				//	   System.out.println("Set buffers");
				createBufferStrategy(2);
				//	   setIgnoreRepaint(true);
				bsInitialized=true;
			}
		}
	}
	
	private void updateScaleFactor(){
	    Dimension size=getSize();
	    if(scaleToComponent){
            
            double scaleX;
            double scaleY;
            if(keepAspectRatio){
             
                double widthRel=(double)size.width/(double)imgWidth;
                double heightRel=(double)size.height/(double)imgHeight;
                
                if(widthRel<heightRel){
                    scaleX=widthRel;
                    scaleY=scaleX;
                }else{
                    scaleY=heightRel;
                    scaleX=scaleY;
                }
            }else{
                scaleX=size.width/(double)imgWidth;
                scaleY=size.height/(double)imgHeight;
            }
          
//          RescaleOp scaleOp=new RescaleOp((float) scaleX, 0f,rh);
            
//            scaleOp = new AffineTransformOp(AffineTransform.getScaleInstance(scaleX, scaleY),AffineTransformOp.TYPE_BILINEAR);
           
        }
//	    else{
//            scaleOp=null;
//        }
	}

	public void setVideoFormat(VideoFormat videoFormat) {
		this.videoFormat=videoFormat;
		if(videoFormat!=null){
			//System.out.println("Pixel aspect ratio: "+videoFormat.getPixelAspectRatio());
			Dimension imgSize=videoFormat.getSize();
			imgWidth=imgSize.width;
			Dimension par=videoFormat.getPixelAspectRatio();
			if(par!=null){
				imgWidth=(imgWidth*par.width)/par.height;
			}

			imgHeight=imgSize.height;
		}
		if(isDisplayable()){
			// TODO neeed
			VolatileImage vi= createVolatileImage(imgWidth, imgHeight);
			Dimension s=getSize();
			setPreferredSize(s);
			//		revalidate();
			doLayout();
		}
	}

	public void decodedVideoFrame(BufferedImage image) {
		if(!isDisplayable()){
			return;
		}
	    //System.out.println(Thread.currentThread().getName());
	    //		System.out.println("AWT!");
	    //		decodedVideoFrame(image, image.getWidth(), image.getHeight());
	    //		synchronized(getTreeLock()){
	    // Render single frame
		
	    BufferStrategy bufferStrategy=getBufferStrategy();
	    if(bufferStrategy!=null){
	        boolean contentsLost=false;
	        do {
	            // The following loop ensures that the contents of the drawing buffer
	            // are consistent in case the underlying surface was recreated
	            boolean contentsRestored=false;
	            do {
	                //            currentFrame=image;

	                //            BufferCapabilities bc=bufferStrategy.getCapabilities();
	                //            System.out.println("Page flipping: "+bc.isPageFlipping()+" full screen required: "+bc.isFullScreenRequired());
	                Graphics g=bufferStrategy.getDrawGraphics();
	                Dimension size=getSize();
	                int w=size.width;
	                int h=size.height;
	                //            System.out.println(size);
	                //            g.drawImage(currentFrame, 0, 0, this);
	                g.drawImage(image,0,0,size.width,size.height,null);
//	                g.drawImage(image, 0, 0, null);
	                //            g.drawImage(image, 0, 0, w, h, 0, 0, 800, 400, null);
	                g.dispose();
	                contentsRestored=bufferStrategy.contentsRestored();
//	                if(contentsRestored){
//	                    System.out.println("Contents restored");
//	                }
	            } while (contentsRestored);

	            bufferStrategy.show();
	            //            System.out.print("Show ...");
	            // Repeat the rendering if the drawing buffer was lost
	            contentsLost=bufferStrategy.contentsLost();
//	            if(contentsLost){
//	                System.out.println("Contents lost");
//	            }
	        } while (contentsLost);
	        //	     Toolkit.getDefaultToolkit().sync();
	        //        }
	        //        repaint();
	    }else{
//	        System.out.println("no buffer strategy.");
	    }
//	    long now=System.nanoTime();
//	    System.out.println("Last frame: "+(now-lastFrame));
//	    lastFrame=now;
	}

    public void activate() {
       validate();
       repaint();
    }

	@Override
	public void decodedVideoFrame(byte[] imageData) {
		// TODO Auto-generated method stub
		
	}

//	@Override
//	public void decodedVideoFrame(BufferedImage image, int width, int height) {
//		imgWidth=(int)((double)width);
//		if(videoFormat!=null){
//			Dimension par=videoFormat.getPixelAspectRatio();
//			if(par!=null){
//				imgWidth=(imgWidth*par.width)/par.height;
//			}
//		}
//		imgHeight=(int)((double)height);
//		synchronized(frameLock){
//		  
//			currentFrame=image;
//		}
//		System.out.println("Repaint frame");
//		repaint();
////		paintImmediately(0, 0, imgWidth, imgHeight);
//	}
//	

}

	