package ips.media.video;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.awt.image.VolatileImage;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JComponent;

public abstract class BufferedImageRenderer implements VideoTrackListener {


	private volatile BufferedImage currentFrame;
	private VideoFormat videoFormat;
	private int imgWidth = 0;
	private int imgHeight = 0;

	
	private JVideoFrameConverter frameConverter;

	
	public BufferedImageRenderer() {
		super();
		frameConverter=new JVideoFrameConverter();
	}



	

	//@Override
	public void setVideoFormat(VideoFormat videoFormat) {
		this.videoFormat = videoFormat;
		if (videoFormat != null) {
			Dimension imgSize = videoFormat.getSize();
			imgWidth = imgSize.width;
			Dimension par = videoFormat.getPixelAspectRatio();
			if (par != null) {
				imgWidth = (imgWidth * par.width) / par.height;
			}

			imgHeight = imgSize.height;
		}
		frameConverter.setVideoFormat(videoFormat);
		
	}

	@Override
	public void decodedVideoFrame(byte[] frameData) {
		BufferedImage bi=frameConverter.convert(frameData);
		decodedVideoFrame(bi);
	}
	
	protected abstract void decodedVideoFrame(BufferedImage image);
	
}
