package ips.media.video;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.awt.image.VolatileImage;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JComponent;

public class JVideoComponent extends JComponent implements VideoTrackListener {

//	public static boolean PAINT_ACTIVE = false;
	public static boolean USE_VOLATILE = true;
	public static boolean USE_SCALE_TRANSFORM = false;
	private volatile BufferedImage currentFrame;
	private VideoFormat videoFormat;
	private Object frameLock = new Object();
	private int imgWidth = 0;
	private int imgHeight = 0;

	private boolean scaleToComponent = true;
	private boolean keepAspectRatio = true;
	private RenderingHints rh;
	private BufferedImageOp scaleOp;
	private double scaleX;
	private double scaleY;

	private volatile VolatileImage bufImg;
	private Image sImg;
	private int sX=0;
	private int sY=0;
	private int sWidth;
	private int sHeight;
	private JVideoFrameConverter frameConverter;

	public boolean isKeepAspectRatio() {
		return keepAspectRatio;
	}

	public void setKeepAspectRatio(boolean keepAspectRatio) {
		this.keepAspectRatio = keepAspectRatio;
	}

	public boolean isScaleToComponent() {
		return scaleToComponent;
	}

	public void setScaleToComponent(boolean scaleToComponent) {
		this.scaleToComponent = scaleToComponent;
	}

	public JVideoComponent() {
		super();
		// setOpaque(true);
		// setIgnoreRepaint(true);
		// setDoubleBuffered(false);

		// rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING,
		// RenderingHints.VALUE_ANTIALIAS_ON);
		// rh.put(RenderingHints.KEY_DITHERING,
		// RenderingHints.VALUE_DITHER_ENABLE);
		//setBackground(Color.BLACK);
		frameConverter=new JVideoFrameConverter();
	}

	// public void paintComponent(Graphics g){
	public void paint(Graphics g) {
//		 super.paint(g);
	    Rectangle r=g.getClipBounds();
	    g.setColor(Color.BLACK);
	    g.fillRect(r.x, r.y, r.width, r.height);
		Graphics2D g2 = (Graphics2D) g;
		synchronized (frameLock) {

			if (!isEnabled() || currentFrame == null) {
				super.paint(g);
			} else {
				currentFrame.setAccelerationPriority(1.0f);
				if (scaleToComponent) {
					if (USE_SCALE_TRANSFORM && scaleOp != null) {
						g2.drawImage(currentFrame, scaleOp, 0, 0);
						// g2.drawImage(currentFrame,0,0,(int)scaleX*imgWidth,(int)scaleY*imgHeight,null);
					} else {
						// int sWidth=(int)(scaleX*(double)imgWidth);
						// int sHeight=(int)(scaleY*(double)imgHeight);
						if (USE_VOLATILE) {

							g2.addRenderingHints(rh);
							// Image sImg=bufImg.getScaledInstance(sWidth,
							// sHeight,VolatileImage.SCALE_SMOOTH);
							// g2.drawImage(bufImg,0,0,null);
							// scale to screen
							g2.drawImage(bufImg, sX, sY, sWidth, sHeight, null);

						} else {
							g2.drawImage(currentFrame, sX, sY, sWidth, sHeight,
									null);
						}
					}
				} else {
					g2.drawImage(currentFrame, 0, 0, imgWidth, imgHeight, null);
				}

			}
		}
	}

	public void doLayout() {
		updateScaleFactor();
		// setOpaque(false);
		// repaint();
		// setOpaque(true);
	}

	public void clear() {
		synchronized (frameLock) {
			currentFrame = null;
			repaint();
		}
	}

	private void updateScaleFactor() {
		Dimension size = getSize();
		int w = size.width;
		int h = size.height;

		if (scaleToComponent && w > 0 && h > 0) {

			if (keepAspectRatio) {

				double widthRel = (double) w / (double) imgWidth;
				double heightRel = (double) h / (double) imgHeight;

				if (widthRel < heightRel) {
					scaleX = widthRel;
					scaleY = scaleX;
				} else {
					scaleY = heightRel;
					scaleX = scaleY;
				}
			} else {
				scaleX = w / (double) imgWidth;
				scaleY = h / (double) imgHeight;
				
			}
			// RescaleOp scaleOp=new RescaleOp((float) scaleX, 0f,rh);

			scaleOp = new AffineTransformOp(AffineTransform.getScaleInstance(
					scaleX, scaleY), AffineTransformOp.TYPE_BILINEAR);
			sWidth = (int) (scaleX * (double) imgWidth);
			sHeight = (int) (scaleY * (double) imgHeight);
		} else {
			scaleOp = null;
			sWidth = imgWidth;
			sHeight = imgHeight;
		}
		sX=0;
		sY=0;
		if(sWidth<w){
		    sX=(w-sWidth)/2;
		}
		if(sHeight<h){
		    sY=(h-sHeight)/2;
		}
		// if(sWidth>0 && sHeight>0){
		// bufImg=createVolatileImage(sWidth, sHeight);
		// }
		if (sWidth > imgWidth || sHeight > imgHeight) {
			rh = new RenderingHints(RenderingHints.KEY_RENDERING,
					RenderingHints.VALUE_RENDER_QUALITY);
		} else {
			rh = new RenderingHints(new HashMap<RenderingHints.Key, Object>());
		}
		// rh.put(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
		// rh.put(RenderingHints.KEY_INTERPOLATION,
		// RenderingHints.VALUE_INTERPOLATION_BILINEAR);
	}

	//@Override
	public void setVideoFormat(VideoFormat videoFormat) {
		this.videoFormat = videoFormat;
		if (videoFormat != null) {
//			System.out.println("Pixel aspect ratio: "
//					+ videoFormat.getPixelAspectRatio());
			Dimension imgSize = videoFormat.getSize();
			imgWidth = imgSize.width;
			Dimension par = videoFormat.getPixelAspectRatio();
			if (par != null) {
				imgWidth = (imgWidth * par.width) / par.height;
			}

			imgHeight = imgSize.height;
		}
		Dimension s = getSize();
		setPreferredSize(s);

		ImageCapabilities ic = new ImageCapabilities(true);

		try {
			bufImg = createVolatileImage(imgWidth, imgHeight, ic);
		} catch (AWTException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			bufImg = createVolatileImage(imgWidth, imgHeight);
		}

		
		frameConverter.setVideoFormat(videoFormat);
		// bufImg.createGraphics();
		revalidate();
		// VolatileImage vi=createVolatileImage(imgWidth, imgHeight);
		// ImageProducer ip=vi.getSource();
		// System.out.println(ip);
	}

	@Override
	public void decodedVideoFrame(byte[] frameData) {
		BufferedImage bi=frameConverter.convert(frameData);
		decodedVideoFrame(bi);
	}
	//@Override
	private void decodedVideoFrame(BufferedImage image) {
//	    Thread t=Thread.currentThread();
//	    System.out.println("Thread ID:"+t.getName()+" "+t.getId());
		// decodedVideoFrame(image, image.getWidth(), image.getHeight());
		synchronized (frameLock) {
			currentFrame = image;
			if (USE_VOLATILE) {

				Graphics2D g = (Graphics2D) bufImg.getGraphics();
				// g.addRenderingHints(rh);
				// g.drawImage(currentFrame, 0,0,sWidth,sHeight, null);
				g.drawImage(currentFrame, 0, 0, null);
				// int sWidth=(int)(scaleX*(double)imgWidth);
				// int sHeight=(int)(scaleY*(double)imgHeight);
				// sImg = bufImg.getScaledInstance(sWidth,
				// sHeight,VolatileImage.SCALE_FAST);
			} else {

			}
		}
//		if (PAINT_ACTIVE) {
//			Dimension s = getSize();
//			// should only be called from AWT Event thread!
//			// http://java.sun.com/products/jfc/tsc/articles/painting/
//			paintImmediately(0, 0, s.width / 2, s.height / 2);
//		} else {
			repaint();
//		}
	}

    //@Override
    public void activate() {
        // TODO Auto-generated method stub
        
    }

	// @Override
	// public void decodedVideoFrame(BufferedImage image, int width, int height)
	// {
	// imgWidth=(int)((double)width);
	// if(videoFormat!=null){
	// Dimension par=videoFormat.getPixelAspectRatio();
	// if(par!=null){
	// imgWidth=(imgWidth*par.width)/par.height;
	// }
	// }
	// imgHeight=(int)((double)height);
	// synchronized(frameLock){
	// currentFrame=image;
	// }
	// // System.out.println("Repaint frame");
	// repaint();
	// Dimension s=getSize();
	// // paintImmediately(0, 0,s.width, s.height);
	// }

}
