/*
 * Date  : 13.05.2012
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ips.media.video;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;

import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

public class JVideoPanel extends JPanel implements VideoTrackListener, AncestorListener{
    private AWTVideoComponent awtVideoComponent;
   
    private int imgWidth = 0;
    private int imgHeight = 0;

    private boolean scaleToComponent = true;
    private boolean keepAspectRatio = true;
    private RenderingHints rh;
    private double scaleX;
    private double scaleY;

    private int sX=0;
    private int sY=0;
    private int sWidth;
    private int sHeight;

    private Dimension videoSize=null;

	private boolean hasAncestor=false;

    public JVideoPanel(){
        super(null);
        setBackground(Color.BLACK);
        awtVideoComponent=new AWTVideoComponent();
        add(awtVideoComponent);
        awtVideoComponent.setLocation(0, 0);
        addAncestorListener(this);
    }
    
    public void setVisible(boolean visible){
    	awtVideoComponent.setVisible(hasAncestor && visible);
    	super.setVisible(visible);
    }
    
    public void addVideoMouseListener(MouseListener l){
    	awtVideoComponent.addMouseListener(l);
    }
    public void removeVideoMouseListener(MouseListener l){
    	awtVideoComponent.addMouseListener(l);
    }
    	
   
    private void updateScaleFactor() {
        Dimension size = getSize();
        int w = size.width;
        int h = size.height;

        if (scaleToComponent && w > 0 && h > 0) {

            if (keepAspectRatio) {

                double widthRel = (double) w / (double) imgWidth;
                double heightRel = (double) h / (double) imgHeight;

                if (widthRel < heightRel) {
                    scaleX = widthRel;
                    scaleY = scaleX;
                } else {
                    scaleY = heightRel;
                    scaleX = scaleY;
                }
            } else {
                scaleX = w / (double) imgWidth;
                scaleY = h / (double) imgHeight;
                
            }
            
            sWidth = (int) (scaleX * (double) imgWidth);
            sHeight = (int) (scaleY * (double) imgHeight);
        } else {
            
            sWidth = imgWidth;
            sHeight = imgHeight;
        }
        sX=0;
        sY=0;
        if(sWidth<w){
            sX=(w-sWidth)/2;
        }
        if(sHeight<h){
            sY=(h-sHeight)/2;
        }
        
        if (sWidth > imgWidth || sHeight > imgHeight) {
            rh = new RenderingHints(RenderingHints.KEY_RENDERING,
                    RenderingHints.VALUE_RENDER_QUALITY);
        } else {
            rh = new RenderingHints(new HashMap<RenderingHints.Key, Object>());
        }
       
    }
    public void doLayout(){
        if(videoSize!=null){
            updateScaleFactor();
            awtVideoComponent.setBounds(sX, sY, sWidth, sHeight);
            //System.out.println("Bounds: "+sX+","+sY+","+sWidth+"x"+sHeight);
        }else{
            // JAWT direct native rendering (Gstreamer xvimagesink xoverlay)
            int w=getWidth();
            int h=getHeight();
            awtVideoComponent.setBounds(0, 0,w, h);
//            awtVideoComponent.setSize(w, h);
//            System.out.println("Set bounds: "+w+"x"+h);
        }
       
    }

    public Canvas getAwtVideoComponent() {
        return awtVideoComponent;
    }

    public void setVideoFormat(VideoFormat videoFormat) {
        videoSize = videoFormat.getSize();
        imgWidth=videoSize.width;
        imgHeight=videoSize.height;
        System.out.println("Set video fromat: "+imgWidth+"x"+imgHeight);
        revalidate();
        awtVideoComponent.setVideoFormat(videoFormat);
    }

    public void decodedVideoFrame(BufferedImage image) {
        awtVideoComponent.decodedVideoFrame(image);
    }

    public void activate() {
       revalidate();
       repaint();
    }

	@Override
	public void decodedVideoFrame(byte[] imageData) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void ancestorAdded(AncestorEvent arg0) {
		hasAncestor=true;
		if(isVisible()){
			awtVideoComponent.setVisible(true);
		}
	}

	@Override
	public void ancestorMoved(AncestorEvent arg0) {
		// no action
	}

	@Override
	public void ancestorRemoved(AncestorEvent arg0) {
		hasAncestor=false;
		// set the AWT canvas (native window) 
		// this avoids flickering when Speechrecorder video prompt presenter is used again (added to the component hierarchy)
		awtVideoComponent.setVisible(false);
	}

 
}
