package ips.media.video;

import java.awt.Dimension;

public class VideoFormat {
	
	
	private Dimension size=null;
	private Dimension pixelAspectRatio=null;
	private int pixelStride;
	public int getPixelStride() {
		return pixelStride;
	}
	private int[] rgbOffsets;
	private boolean hasAlpha;
	public boolean isHasAlpha() {
		return hasAlpha;
	}
	private boolean linesBottomUp=false;
	
	public boolean isLinesBottomUp() {
		return linesBottomUp;
	}

	public int[] getRgbOffsets() {
		return rgbOffsets;
	}

	public Dimension getPixelAspectRatio() {
		return pixelAspectRatio;
	}

	public void setPixelAspectRatio(Dimension pixelAspectRatio) {
		this.pixelAspectRatio = pixelAspectRatio;
	}

	public Dimension getSize() {
		return size;
	}
	public VideoFormat(int pixelStride,int[] rgbOffsets,boolean hasAlpha,int width,int height,int parWidth,int parHeight){
		this(pixelStride,rgbOffsets,hasAlpha,false,width,height,parWidth,parHeight);
	}
	public VideoFormat(int pixelStride,int[] rgbOffsets,boolean hasAlpha,boolean linesBottomUp,int width,int height,int parWidth,int parHeight){
		this(pixelStride,rgbOffsets,width,height);
		pixelAspectRatio=new Dimension(parWidth, parHeight);
	}
	public VideoFormat(int pixelStride,int[] rgbOffsets,int width,int height){
		this(pixelStride,rgbOffsets,false,false,width,height);
	}
	public VideoFormat(int pixelStride,int[] rgbOffsets,boolean hasAlpha,boolean linesBottomUp,int width,int height){
		super();
		this.pixelStride=pixelStride;
		this.rgbOffsets=rgbOffsets;
		this.hasAlpha=hasAlpha;
		this.linesBottomUp=linesBottomUp;
		size=new Dimension(width,height);
	}

	public VideoFormat(int width, int height) {
		this(3,new int[]{0,1,2},width,height);
	}
}
