package ips.media;

import java.awt.BufferCapabilities;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.List;

import ips.media.spi.NativeMediaSystem;
import ipsk.util.services.ServicesInspector;



public  class NativeMediaSystemsManager extends
		ServicesInspector<NativeMediaSystem> {
	private final static boolean DEBUG=false;
	private static volatile NativeMediaSystemsManager instance=null;
	protected NativeMediaSystemsManager() {
		super(NativeMediaSystem.class);
	}
	
	public static synchronized NativeMediaSystemsManager getInstance(){
		if(instance==null){
			instance=new NativeMediaSystemsManager();
		}
		return instance;
	}

	public static NativeMediaSystem createDefaultNativeMediaSystem()
			throws NativeMediaSystemException {
		NativeMediaSystemsManager nmsm = NativeMediaSystemsManager.getInstance();
		List<Class<? extends NativeMediaSystem>> nmClassList = null;
		try {
			nmClassList = nmsm.getServiceImplementorClasses(true);
		} catch (IOException e2) {
			throw new NativeMediaSystemException(e2);
		} catch (ClassNotFoundException e2) {
			throw new NativeMediaSystemException(e2);
		}
		if (nmClassList == null || nmClassList.size() == 0) {
			return null;
		}
		Class<? extends NativeMediaSystem> nmClass = nmClassList.get(0);
		NativeMediaSystem nms = null;
		try {
			nms = nmClass.newInstance();
		} catch (InstantiationException e1) {
			throw new NativeMediaSystemException(e1);
		} catch (IllegalAccessException e1) {
			throw new NativeMediaSystemException(e1);
		}
		return nms;
	}


	public static void printPerformanceInfo(){
	    GraphicsEnvironment ge=GraphicsEnvironment.getLocalGraphicsEnvironment();
	    GraphicsDevice[] sdvs=ge.getScreenDevices();
	    for(GraphicsDevice gd:sdvs){
	        System.out.println("Graphics device: "+gd);
	    GraphicsConfiguration[] gcs=gd.getConfigurations();
	    for(GraphicsConfiguration gc:gcs){
	        System.out.println("Graphics configuration: "+gc);
	        BufferCapabilities bc=gc.getBufferCapabilities();
	        System.out.println("Page flipping: "+bc.isPageFlipping()+" full screen required: "+bc.isFullScreenRequired());
	    }
	    }
	}
	
	public static void main(String[] args){
	    NativeMediaSystemsManager.printPerformanceInfo();
	}
	
}
