//    IPS Java Speech Database
//    (c) Copyright 2011
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Speech Database
//
//
//    IPS Java Speech Database is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Speech Database is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Speech Database.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.db.speech.project;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.Unit;
import ipsk.db.speech.Project;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

/**
 * Media capture format.
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */
@Entity
@Table(name = "media_capture_format", schema = "public")
@ResourceBundleName("ipsk.db.speech.PropertyNames")
@ResourceKey("media.capture.format")
@PreferredDisplayOrder("audioChannelCount,audioSampleRate,audioQuantisationBits")
public class MediaCaptureFormat {

	private String name;
	
	@Id
	@Column(nullable = false)
    @ResourceKey("name")
    @XmlTransient
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name= name;
	}

	private Project project;
	
	@MapsId
	@OneToOne
	@JoinColumn(name = "name")
	@XmlTransient
	public Project getProject() {
		return project;
	}

	public void setProject(Project project) {
		this.project = project;
	}

	//private boolean captureVideo=false;
    private int audioChannelCount = 2;
    private double audioSampleRate = 44100;
    private int audioQuantisationBits = 16;
    
  
    public MediaCaptureFormat() {
    	super();
    }
    
    /**
     * Number of channels.
     * @return number of channels
     */
    @Column(name = "audioChannelCount")
    @ResourceKey("channels")
    public int getAudioChannelCount() {
        return audioChannelCount;
    }

    /**
     * Get samplerate.
     * @return samplerate in Hz
     */
    @Column(name = "audioSamplerate")
    @ResourceKey("samplerate")
    @Unit("Hz")
    public double getAudioSampleRate() {
        return audioSampleRate;
    }

    /**
     * Get audio quantisation (sample size in bits), e.g. 16 for CD-DA Quality.
     * @return audio quantisation
     */
    @Column(name = "audioQuantisationBits")
    @ResourceKey("quantisation")
    public int getAudioQuantisationBits() {
        return this.audioQuantisationBits;
    }
    
    /**
     * Set number of audio channels.
     * @param channelCount
     */
    public void setAudioChannelCount(int channelCount) {
        audioChannelCount = channelCount;
    }

    
    /**
     * Set audio sample rate in Hz.
     * @param d
     */
    public void setAudioSampleRate(double d) {
        audioSampleRate = d;
    }

    /**
     * Set audio quantisation in bits.
     * @param quantisation
     */
    public void setAudioQuantisationBits(int quantisation) {
        this.audioQuantisationBits = quantisation;
    }

    public String toString() {
    	return "Audio: "+audioChannelCount+" Chs, "+audioSampleRate+" Hz, "+audioQuantisationBits+" bits";
    }
    
}
