package ips.apps.speechrecorder.startstopsignal;


import java.awt.GridLayout;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Separate Ampelmaennchen implementation. The Ampelmaennchen pedestrian light is
 * separated, because we do not want to redistribute the icons in the open
 * source distribution of Speechrecorder.
 * 
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 * 
 *         RecMonitor displays a vertical panel with a pedestrian light to monitor
 *         the recording. A red light means that no speech is recorded  and a
 *         green light indicates that the speaker may speak.
 * 
 * @author Christoph Draxler
 * 
 */

public class AmpelmaennchenPedestrianLights extends JPanel implements
        ipsk.apps.speechrecorder.monitor.StartStopSignal{
   
    // width of the panels is the width of the images plus 2 pixel left and
    // right
    // height is three times the image height plus 2 pixel on top and bottom
//    final private int width = 64 + 4;
//    final private int height = 192 + 4;

    private ImageIcon redOn;
    private ImageIcon redOff;
  
    private ImageIcon greenOn;
    private ImageIcon greenOff;

    private JLabel redLabel = null;
   
    private JLabel greenLabel = null;

    /**
     * RecMonitor consists of six image files, two lights of the pedestrian light
     * either on or off. The images are organized in a vertical box layout.
     */
    public AmpelmaennchenPedestrianLights() {
        super();

        redOn = new ImageIcon(getClass().getResource("icons/redOn.gif"));
        redOff = new ImageIcon(getClass().getResource("icons/redOff.gif"));
        greenOn = new ImageIcon(getClass().getResource("icons/greenOn.gif"));
        greenOff = new ImageIcon(getClass().getResource("icons/greenOff.gif"));

        //setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        setLayout(new GridLayout(3,1));

        redLabel = new JLabel(redOff);
        greenLabel = new JLabel(greenOff);
        add(redLabel);
        add(greenLabel);

       
        setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }
 

    /**
     * Changes the status of the pedestrian lights depending on the current
     * recording status.
     */
    public void setStatus(State status) {
        if (status.equals(State.OFF)) {
            redLabel.setIcon(redOff);
            greenLabel.setIcon(greenOff);
        } else if (status.equals(State.IDLE)) {
            redLabel.setIcon(redOn);
            greenLabel.setIcon(greenOff);
        } else if (status.equals(State.PRERECORDING)) {
            redLabel.setIcon(redOn);
            greenLabel.setIcon(greenOff);
        } else if (status.equals(State.POSTRECORDING)) {
            redLabel.setIcon(redOn);
            greenLabel.setIcon(greenOff);
        } else if (status.equals(State.RECORDING)) {
            redLabel.setIcon(redOff);
            greenLabel.setIcon(greenOn);
        }
    }

    public JComponent getComponent() {

        return this;
    }

}
