package ips.apps.speechrecorder.startstopsignal;


import java.awt.GridLayout;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Separate Ampelmaennchen implementation. The Ampelmaennchen traffic light is
 * separated, because we do not want to redistribute the icons in the open
 * source distribution of Speechrecorder.
 * 
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 * 
 *         RecMonitor displays a vertical panel with a traffic light to monitor
 *         the recording. A red light means that no speech is recorded, yellow
 *         is displayed when the recording is about to begin or has ended, and a
 *         green light indicates that the speaker may speak.
 * 
 * @author Christoph Draxler
 * 
 */

public class Ampelmaennchen extends JPanel implements
        ipsk.apps.speechrecorder.monitor.StartStopSignal{
   
    // width of the panels is the width of the images plus 2 pixel left and
    // right
    // height is three times the image height plus 2 pixel on top and bottom
//    final private int width = 64 + 4;
//    final private int height = 192 + 4;

    private ImageIcon redOn;
    private ImageIcon redOff;
    private ImageIcon yellowOn;
    private ImageIcon yellowOff;
    private ImageIcon greenOn;
    private ImageIcon greenOff;

    private JLabel redLabel = null;
    private JLabel yellowLabel = null;
    private JLabel greenLabel = null;

    /**
     * RecMonitor consists of six image files, three lights of the traffic light
     * either on or off. The images are organized in a vertical box layout.
     */
    public Ampelmaennchen() {
        super();

        redOn = new ImageIcon(getClass().getResource("icons/redOn.gif"));
        redOff = new ImageIcon(getClass().getResource("icons/redOff.gif"));
        yellowOn = new ImageIcon(getClass().getResource("icons/yellowOn.gif"));
        yellowOff = new ImageIcon(getClass().getResource("icons/yellowOff.gif"));
        greenOn = new ImageIcon(getClass().getResource("icons/greenOn.gif"));
        greenOff = new ImageIcon(getClass().getResource("icons/greenOff.gif"));

        //setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        setLayout(new GridLayout(3,1));

        redLabel = new JLabel(redOff);
        yellowLabel = new JLabel(yellowOff);
        greenLabel = new JLabel(greenOff);
        add(redLabel);
        add(yellowLabel);
        add(greenLabel);

       
        setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }
 
//    public void paintComponent(Graphics g){
//        g.drawImage
//    }
    

    /**
     * Changes the status of the traffic lights depending on the current
     * recording status.
     */
    public void setStatus(State status) {
        if (status.equals(State.OFF)) {
            redLabel.setIcon(redOff);
//            System.out.println(redLabel.getBounds()+" "+redOff.getIconWidth()+" "+redOff.getIconHeight());
            yellowLabel.setIcon(yellowOff);
            greenLabel.setIcon(greenOff);
        } else if (status.equals(State.IDLE)) {
            redLabel.setIcon(redOn);
            yellowLabel.setIcon(yellowOff);
            greenLabel.setIcon(greenOff);
        } else if (status.equals(State.PRERECORDING)) {
            redLabel.setIcon(redOn);
            yellowLabel.setIcon(yellowOn);
//            System.out.println(yellowLabel.getBounds()+" "+yellowOn.getIconWidth()+" "+yellowOn.getIconHeight());
            greenLabel.setIcon(greenOff);
        } else if (status.equals(State.POSTRECORDING)) {
            redLabel.setIcon(redOff);
            yellowLabel.setIcon(yellowOn);
            greenLabel.setIcon(greenOff);
        } else if (status.equals(State.RECORDING)) {
            redLabel.setIcon(redOff);
            yellowLabel.setIcon(yellowOff);
            greenLabel.setIcon(greenOn);
//            System.out.println(greenLabel.getBounds()+" "+greenOn.getIconWidth()+" "+greenOn.getIconHeight());
        }
    }

    public JComponent getComponent() {

        return this;
    }

}
