//    IPS SVG prompt presenter
//    (c) Copyright 2012
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS SVG prompt presenter
//
//
//    IPS SVG prompt presenter is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS SVG prompt presenter is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS SVG prompt presenter.  If not, see <http://www.gnu.org/licenses/>.

 
package ips.prompting;

import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.net.URLContext;

import java.awt.BorderLayout;
import java.awt.geom.Dimension2D;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

import javax.swing.BorderFactory;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;

/**
 * SVG prompt presenter for SpeechRecorder.
 * Based on Apache Batik.
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

public class SVGPromptPresenter extends BasicPromptPresenter implements  AncestorListener {

    private final static boolean DEBUG=false;
    private static PromptPresenterServiceDescriptor DESCRIPTOR=new SVGPromptPresenterServiceDescriptor();
    private JSVGCanvas svgCanvas;
    private Dimension2D svgDim=null;
    private String contentUri=null;
    private Object renderedNotify=new Object();
   
    public SVGPromptPresenter(){
        super(new BorderLayout());
        if(DEBUG)System.out.println(getClass().getName()+" loaded");
        setBorder(BorderFactory.createEtchedBorder());
      
        svgCanvas=new JSVGCanvas();
        svgCanvas.setRecenterOnResize(true);
      
        add(svgCanvas,BorderLayout.CENTER);
     
        //svgCanvas.setMySize(new Dimension(400,100));
       
        svgCanvas.addSVGDocumentLoaderListener(new SVGDocumentLoaderAdapter() {
            public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
                if(DEBUG)System.out.println("Document Loading...");
            }
            public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
                if(DEBUG)System.out.println("Document Loaded.");
            }
        });

        svgCanvas.addGVTTreeBuilderListener(new GVTTreeBuilderAdapter() {
            public void gvtBuildStarted(GVTTreeBuilderEvent e) {
                if(DEBUG)System.out.println("Build Started...");
            }
            public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                if(DEBUG)System.out.println("Build Done.");
                //frame.pack();
            }
        });

        svgCanvas.addGVTTreeRendererListener(new GVTTreeRendererAdapter() {
            public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
                if(DEBUG)System.out.println(this+" Rendering Started...");
            }
            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
//                if(svgDim==null){
//                    svgDim=svgCanvas.getSVGDocumentSize();
//                    Dimension cd=getSize();
//                    System.out.println(cd);
//                    double sx=(double)(cd.width)/svgDim.getWidth();
//                    double sy=(double)(cd.height)/svgDim.getHeight();
//                    System.out.println("scale: "+sx+" "+sy);
//                    //svgCanvas.setPreferredSize(new Dimension((int)(svgDim.getWidth()*2),(int)(svgDim.getHeight()*2)));
//                    
//                    svgCanvas.setRenderingTransform(AffineTransform.getScaleInstance(sx, sy),true);
//                    repaint();
//                }
                if(DEBUG){
                System.out.println(this+" Rendered doc size: "+svgCanvas.getSVGDocumentSize());
                System.out.println("Rendered canvas size: "+svgCanvas.getSize());
                System.out.println("RenderEvent is dispatch thread: "+java.awt.EventQueue.isDispatchThread());
                }
               
            }
        });
     
       addAncestorListener(this);
    }
    
    
    
    
    /**
     * @param args
     */
    public static void main(String[] args) {
        
//        Runnable doUI=new Runnable(){
//
//            public void run() {
//                JFrame f=new JFrame();
//                JFrame f2=new JFrame();
//            
//                SVGPromptPresenter svgPp=new SVGPromptPresenter();
//                
//                f.getContentPane().add(svgPp);
//                f.setVisible(false);
//                SVGPromptPresenter svgPp2=new SVGPromptPresenter();
//                f2.getContentPane().setLayout(new BorderLayout());
//                f2.add(new JLabel("Hallo"),BorderLayout.WEST);
//                f2.setVisible(false);
//                try {
//                    svgPp.setContents(new URL("file:/homes/klausj/TESTFILES/Zeichen_224.svg"));
//                   
//                } catch (MalformedURLException e) {
//                    // TODO Auto-generated catch block
//                    e.printStackTrace();
//                }
//                try {
//                    svgPp2.setContents(new URL("file:/homes/klausj/TESTFILES/Zeichen_224.svg"));
//                } catch (MalformedURLException e) {
//                    // TODO Auto-generated catch block
//                    e.printStackTrace();
//                }
//                try {
//                    Thread.sleep(1000);
//                } catch (InterruptedException e) {
//                    // TODO Auto-generated catch block
//                    e.printStackTrace();
//                }
//                
//                f.pack();
//                //f.setExtendedState(JFrame.MAXIMIZED_BOTH);
//                f.setVisible(true);
//
//                
//                f2.getContentPane().add(svgPp2,BorderLayout.CENTER);
//                try {
//                    Thread.sleep(2000);
//                } catch (InterruptedException e1) {
//                    // TODO Auto-generated catch block
//                    e1.printStackTrace();
//                }
//                f2.pack();
//                f2.setExtendedState(JFrame.MAXIMIZED_BOTH);
//                f2.setVisible(true);
//               
//                
//            }
//            
//        };
//        
//        SwingUtilities.invokeLater(doUI);
//        

    }




    public void hideContents() {
        // TODO Auto-generated method stub
        
    }




    public void loadContents(URL url) {
       // TODO load here
    }


    private void reloadContent(){
        
            
            svgCanvas.setURI(contentUri);
//            while(!rendered){
//            synchronized(renderedNotify){
//                try {
//                    System.out.println("Wait ...");
//                    renderedNotify.wait();
//                } catch (InterruptedException e) {
//                  // OK
//                }
//                System.out.println("Notified.");
//            }
//            }
        
    }
    
    public void setContents(URL url, String description, String type,
            String charset) {
        try {
            contentUri=url.toURI().toString();
        } catch (URISyntaxException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
            reloadContent();
         
    }




    public void showContents() {
        // TODO Auto-generated method stub
        
    }




    public void setContents(String string, String description, String type) {
        
        
    }





    public void ancestorAdded(AncestorEvent event) {
       reloadContent();
        
    }




    public void ancestorMoved(AncestorEvent event) {
        // TODO Auto-generated method stub
        
    }




    public void ancestorRemoved(AncestorEvent event) {
       svgCanvas.stopProcessing();
       svgCanvas.dispose();
        
    }




  


    public void loadContents()
            throws PromptPresenterException {
        if(mediaitems==null || mediaitems.length==0){
            throw new UnsupportedContentException("No media item to display!");
        }else if(mediaitems.length > 1){
            throw new UnsupportedContentException("Multiple media items not supported!");
        }  
        
        Mediaitem mi=mediaitems[0];
        URI miurl=mi.getSrc();
        
        try {
            URL url=URLContext.getContextURL(contextURL, miurl.toString());
            contentUri=url.toURI().toString();
        } catch (URISyntaxException e) {
           throw new PromptPresenterException(e);
        } catch (MalformedURLException e) {
            throw new PromptPresenterException(e);
        }
         reloadContent();
    }




    public PromptPresenterServiceDescriptor getServiceDescriptor() {
//        return new SVGPromptPresenterServiceDescriptor();
    	return DESCRIPTOR;
        
    }
    
    

}
