//    IPS SVG prompt presenter
//    (c) Copyright 2012
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS SVG prompt presenter
//
//
//    IPS SVG prompt presenter is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS SVG prompt presenter is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS SVG prompt presenter.  If not, see <http://www.gnu.org/licenses/>.

 
/**
 * SVG and audio presenter using JavaSound audio.
 *
 * @author Klaus Jaensch
 */

package ips.prompting;

import javax.sound.sampled.Mixer;
import javax.swing.Action;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.prompting.MediaPromptPresenter2;
import ipsk.apps.speechrecorder.prompting.PromptAudioJavaSound;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterListener;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterPluginException;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.audio.ChannelGroupLocator;
import ipsk.db.speech.script.prompt.Mediaitem;

/**
 *  SVG and audio prompt presenter for SpeechRecorder.
 *  Based on Apache Batik.
 *  @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
public class SVGAndAudioJavaSoundPromptPresenter extends SVGPromptPresenter implements MediaPromptPresenter2{
//    public static final PromptPresenterServiceDescriptor DESCRIPTOR=new BasicPromptPresenterServiceDescriptor(PlainTextAndAudioJavaSoundViewer.class.getName(),new LocalizableMessage("Plain text and audio prompter"), "Institute of Phonetics and Speech processing, Munich", new ipsk.text.Version(new int[]{1,0,0}), new LocalizableMessage("Presents plain text and audio at the same time."),PlainTextAndAudioJavaSoundViewer.getSupportedMIMETypes());
    private Mediaitem audioMediaitem;
    private PromptAudioJavaSound audioJavaSoundPrompter;
    public void setAudioChannelOffset(int channelOffset) {
		audioJavaSoundPrompter.setAudioChannelOffset(channelOffset);
	}

	public void setAudioChannelGroupLocator(ChannelGroupLocator channelGroupLocator)
			throws PromptPresenterPluginException {
		audioJavaSoundPrompter.setAudioChannelGroupLocator(channelGroupLocator);
	}
	private static PromptPresenterServiceDescriptor DESCRIPTOR=new SVGAndAudioJavaSoundPromptPresenterServiceDescriptor();
   public SVGAndAudioJavaSoundPromptPresenter() {
        super();
        audioJavaSoundPrompter=new PromptAudioJavaSound();
    }
   
   public void setContents(Mediaitem[] mediaitems) throws PromptPresenterException{
       if(mediaitems.length != 2){
           throw new UnsupportedContentException("Only SVG and audio combinations are supported!");
       }  
       
       for(Mediaitem mi:mediaitems){
           if(SVGPromptPresenterServiceDescriptor.SVG_MIME_TYPE.equalsIgnoreCase(mi.getNNMimetype())){
               super.setContents(new Mediaitem[]{mi});
           }
           if(MIMETypes.isOfType(mi.getNNMimetype(), MIMETypes.AUDIOMIMETYPES)){
               audioMediaitem=mi;
              
           }
           
       }
   }
    
    public void loadContents()
    throws PromptPresenterException {
   
    super.loadContents();
    audioJavaSoundPrompter.loadAudioContents(audioMediaitem, contextURL);
    }

    public static String[][] getSupportedMIMETypes() {
    	int combinations=MIMETypes.AUDIOMIMETYPES.length;
    	String[][] mtypes=new String[combinations][];
//    	int ci=0;
    	for(int j=0;j<MIMETypes.AUDIOMIMETYPES.length;j++){
    		mtypes[j]=new String[]{SVGPromptPresenterServiceDescriptor.SVG_MIME_TYPE,MIMETypes.AUDIOMIMETYPES[j]};
    	}
    	return mtypes;
    }

    public void close() {
        audioJavaSoundPrompter.close();
    }

    public boolean isSilent() {
        return audioJavaSoundPrompter.isSilent();
    }

    public void open() throws PromptPresenterException {
        audioJavaSoundPrompter.open();
    }

    public void setAudioMixer(Mixer mixer)
            throws PromptPresenterPluginException {
        audioJavaSoundPrompter.setAudioMixer(mixer);
    }

    public void setSilent(boolean silent) {
        audioJavaSoundPrompter.setSilent(silent);
    }

    public void setStartControlAction(Action startControlAction) {
        audioJavaSoundPrompter.setStartControlAction(startControlAction);
    }

    public void setStartControlEnabled(boolean startEnabled) {
        audioJavaSoundPrompter.setStartControlEnabled(startEnabled);
    }

    public void setStopControlAction(Action stopControlAction) {
        audioJavaSoundPrompter.setStopControlAction(stopControlAction);
    }

    public void setStopControlEnabled(boolean stopEnabled) {
        audioJavaSoundPrompter.setStopControlEnabled(stopEnabled);
    }

    public void start() throws PromptPresenterException {
        audioJavaSoundPrompter.start();
    }

    public void stop() {
        audioJavaSoundPrompter.stop();
    }

    public void addPromptPresenterListener(PromptPresenterListener listener) {
        super.addPromptPresenterListener(listener);
        audioJavaSoundPrompter.addPromptPresenterListener(listener);
    }

    public void removePromptPresenterListener(PromptPresenterListener listener) {
        super.removePromptPresenterListener(listener);
        audioJavaSoundPrompter.removePromptPresenterListener(listener);
    }
    /* (non-Javadoc)
     * @see ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter#getServiceDescriptor()
     */
    public PromptPresenterServiceDescriptor getServiceDescriptor() {
    	 return DESCRIPTOR;
    }

	@Override
	public boolean requiresDisplayableToRun(){
		return false;
	}

}
