//    Speechrecorder
//    (c) Copyright 2012
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.
 
package ipsk.apps.speechrecorder.script.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.AbstractAction;
import javax.swing.Action;

/**
 * Backward action.
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

public class TogglePromptAsAnnotationTemplateAction extends AbstractAction{

public final static String ACTION_COMMAND = new String("prompt_as_annotation_template_widget_changed");
    
    private ActionListener listener;
    
    public ActionListener getListener() {
        return listener;
    }


    public void setListener(ActionListener listener) {
        this.listener = listener;
    }


    public TogglePromptAsAnnotationTemplateAction() {
        super();
        putValue(Action.NAME, "Use as annotation template");
        putValue(Action.ACTION_COMMAND_KEY,ACTION_COMMAND);
    }


    public void actionPerformed(ActionEvent arg0) {
        if(isEnabled()){
            listener.actionPerformed(arg0);
                
        }
    }


}
