//    Speechrecorder
//    (c) Copyright 2012
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.apps.speechrecorder.db;

import ipsk.apps.speechrecorder.Speakers;
import ipsk.swing.JDialogPanel;
import ipsk.swing.text.TableTextfileExporter;
import ipsk.text.TableTextFormats;
import ipsk.util.SystemHelper;

public class ExportSpeakersUIDialog extends JDialogPanel {

    private TableTextfileExporter<Speakers.SpeakersTableSchemaProvider,Speakers> tableTextfileExporter;
	

	public ExportSpeakersUIDialog() {
	    super(JDialogPanel.Options.NONE);
	    setFrameTitle("Export speaker database to text list/table");
	    setApplyingEnabled(false);
        tableTextfileExporter=new TableTextfileExporter<Speakers.SpeakersTableSchemaProvider,Speakers>(Speakers.getTableSchemaProvider());
        TableTextFormats.Profile defaultProfile;
        if(SystemHelper.getInstance().isWindows()){
            defaultProfile=TableTextFormats.Profile.TAB_SEP_WIN;
        }else{
            defaultProfile=TableTextFormats.Profile.TAB_SEP_UNIX;
        }
        tableTextfileExporter.setSelectedProfile(defaultProfile);
        add(tableTextfileExporter);
	}
	

	public void setSpeakers(Speakers speakers){
	    tableTextfileExporter.setData(speakers);
	}

	
}
