//    Speechrecorder
//    (c) Copyright 2012
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.apps.speechrecorder.annotation.auto;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import ipsk.swing.JDialogPanel;

public class ProjectUpdateAutoAnnotationsUIDialog extends JDialogPanel {

    private JCheckBox overwriteAnnoFilesCheckBox;

    public ProjectUpdateAutoAnnotationsUIDialog() {
        // super(JUpdateManagerConfigPanel.OK_APPLY_CANCEL_OPTION);
        super(JDialogPanel.Options.OK_CANCEL);
        okButton.setText("Update");
        setFrameTitle("Update (auto) annotations of project");
        setApplyingEnabled(false);
        JPanel cfgP = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        Insets ins = new Insets(1, 1, 1, 1);
        gc.insets = ins;
        gc.gridx = 0;
        gc.gridy = 0;
        overwriteAnnoFilesCheckBox = new JCheckBox("Overwrite existing annotations files?");
        overwriteAnnoFilesCheckBox.setSelected(false);
        gc.gridwidth = 2;
        cfgP.add(overwriteAnnoFilesCheckBox, gc);

        getContentPane().add(cfgP);
        setApplyingEnabled(true);
    }

    public boolean isOverwriteAnnoFiles() {
        return overwriteAnnoFilesCheckBox.isSelected();
    }

    protected void applyValues() {
        super.applyValues();
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        super.actionPerformed(ae);
    }

}
