//    Speechrecorder
//    (c) Copyright 2012
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.apps.speechrecorder.script.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import ipsk.db.speech.script.Script;
import ipsk.swing.JDialogPanel;
import ipsk.swing.XMLFileFilter;

public class ExportScriptUIDialog extends JDialogPanel {

	//private JCheckBox applyProjectDefaultsCheckBox;

	private JTextField filePathField;

	private JButton browseButton;

	public ExportScriptUIDialog() {
		super(JDialogPanel.Options.OK_CANCEL);

		setFrameTitle("Export recording script");
		setApplyingEnabled(false);

		okButton.setText("Export");

		setApplyingEnabled(false);
		 getContentPane().setLayout(new GridBagLayout());
		JPanel cfgP = new JPanel(new GridBagLayout());
		GridBagConstraints gc = new GridBagConstraints();
		Insets ins = new Insets(1, 1, 1, 1);
		gc.insets = ins;
		gc.gridx = 0;
		gc.gridy = 0;
		
//		applyProjectDefaultsCheckBox = new JCheckBox("Apply project defaults");
//		applyProjectDefaultsCheckBox.setSelected(applyProjectDefaults);
//		// TODO not supported yet
//		applyProjectDefaultsCheckBox.setEnabled(false);
//		gc.gridwidth = 3;
//		cfgP.add(applyProjectDefaultsCheckBox, gc);
//
//		gc.gridy++;
		gc.gridwidth = 1;
		cfgP.add(new JLabel("Script XML File:"), gc);
		gc.gridx++;
		gc.weightx = 2.0;
		gc.fill = GridBagConstraints.HORIZONTAL;
		filePathField = new JTextField(20);
		cfgP.add(filePathField, gc);
		browseButton = new JButton("Browse...");
		gc.gridx++;
		gc.fill = GridBagConstraints.NONE;
		gc.weightx = 0.0;
		cfgP.add(browseButton, gc);
		browseButton.addActionListener(this);
		getContentPane().add(cfgP);

	}

	public void setScript(Script script) {

	}

	private JFileChooser fileChooser;
	
	private boolean applyProjectDefaults=false;
	
	public boolean isApplyProjectDefaults() {
		return applyProjectDefaults;
	}

	public void setApplyProjectDefaults(boolean applyProjectDefaults) {
		this.applyProjectDefaults = applyProjectDefaults;
	}

	private File exportFile;

	public File getExportFile() {
		return exportFile;
	}

	public void setExportFile(File exportFile) {
		this.exportFile = exportFile;
		if (exportFile != null) {
			setApplyingEnabled(true);
		}
		String path = exportFile.getAbsolutePath();

		filePathField.setText(path);
	}
	
	 protected void applyValues(){
		 //setApplyProjectDefaults(applyProjectDefaultsCheckBox.isSelected());
	     String path=filePathField.getText();
	     
	     if(! "".equals(path)){
	         setExportFile(new File(path)); 
	     }
	     super.applyValues();
     }


	public void actionPerformed(ActionEvent ae) {
		Object src = ae.getSource();

		if (src == browseButton) {
			fileChooser = new JFileChooser();
			fileChooser.setFileFilter(new XMLFileFilter());
			fileChooser.setAcceptAllFileFilterUsed(true);
			fileChooser.setSelectedFile(exportFile);
			int res = fileChooser.showDialog(this, "Select");
			if (res == JFileChooser.APPROVE_OPTION) {
				setExportFile(fileChooser.getSelectedFile());
			}
		} else {
			super.actionPerformed(ae);
		}
	}

}
