package ipsk.jsp.taglib;

import ips.servlet.http.URLEncoder;
import ipsk.text.html.HTMLTextEncoder;
import ipsk.util.LocalizableMessage;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class ExtBodyTagSupport extends BodyTagSupport {

	public final static String RES_BUNDLE_NAME="ipsk.jsp.Messages"; 
	protected String key;
	protected String bundle;
	protected ServletContext servletContext;

	
	public void setPageContext(PageContext pageContext){
		super.setPageContext(pageContext);
		servletContext=pageContext.getServletContext();
	}
	public int doStartTag() throws JspException {
		
		JspWriter ow = pageContext.getOut();
		if (key!=null) {
		try {
			ow.println(LocaleSupport.getLocalizedMessage(pageContext,key,RES_BUNDLE_NAME));
		} catch (IOException e) {
			throw new JspException(e);
		}
		}
		return SKIP_BODY;
	}

	public int doEndTag() throws JspException {
		
		return EVAL_PAGE;
	}

	public String getLocalizedMessage(){
		return getLocalizedMessage(key);
	}
	public String getLocalizedMessage(String key){
		return getLocalizedMessage(key,RES_BUNDLE_NAME);
	}
	public String getLocalizedMessage(LocalizableMessage localizableMessage){
		String key=localizableMessage.getResourceKey();
		String bundle=localizableMessage.getResourceBundleName();
		Object[] args=localizableMessage.getArguments();
		if(key!=null){
			if(bundle !=null){
				if(args!=null){
					return LocaleSupport.getLocalizedMessage(pageContext, key,args,bundle);
				}else{
					return LocaleSupport.getLocalizedMessage(pageContext, key,bundle);
				}
			}
		}
		// fallback
		return localizableMessage.localize();
	}
	public String getLocalizedMessage(String key,String bundle){
		return LocaleSupport.getLocalizedMessage(pageContext, key,bundle);
	}
	
	
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getBundle() {
		return bundle;
	}

	public void setBundle(String bundle) {
		this.bundle = bundle;
	}
	
	public String encodeURL(String url){
		return URLEncoder.encodeURL(pageContext, url);
	}


}
