package ipsk.jsp.taglib.beans;

import ipsk.beans.PropertyValidationResult;
import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.text.html.HTMLTextEncoder;
import ipsk.util.LocalizableMessage;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;

public class BeanPropertyValidationResultTag extends ExtBodyTagSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	protected BeanProperty beanProperty=null;
	
	public void setParent(Tag parent){
		Tag bpParent=parent;
		
		while(bpParent!=null && !(bpParent instanceof ipsk.jsp.taglib.beans.BeanPropertyProvider)){
			bpParent=bpParent.getParent();
		}
		if(bpParent !=null && bpParent instanceof ipsk.jsp.taglib.beans.BeanPropertyProvider){
			beanProperty=((ipsk.jsp.taglib.beans.BeanPropertyProvider)bpParent).getBeanProperty();
		}
	}
	
	
	public int doStartTag() throws JspException {	
		PropertyValidationResult pvr=beanProperty.getValidationResult();

		try{
			JspWriter ow=pageContext.getOut();
			if(pvr != null){
				LocalizableMessage msg=pvr.getValidationMessage();
				if(msg!=null){
					ow.print("<td class=\"error\">"+HTMLTextEncoder.encode(getLocalizedMessage(msg))+"</td>");
				}else{
					ow.print("<td class=\"error\">"+HTMLTextEncoder.encode(getLocalizedMessage("validation.field.invalid"))+"</td>");
				}
			}
		}catch(Exception e){
			throw new JspException("Could not print bean property validation result!",e);
		}
		return SKIP_BODY;

	}

	public int doEndTag() throws JspException {
		
		return EVAL_PAGE;
	}


}
