package ipsk.webapps;

import ipsk.persistence.Controller;
import ipsk.persistence.EntityManagerProviderImpl;
import ipsk.persistence.SecurityManager;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;

public class BasicPersistenceController extends EntityManagerProviderImpl implements Controller{

	
	// Toplink Essentials JPA implementation does not work with
	// full classified class names in JPA queries e.g.
	// SELECT o FROM ipsk.speechdb.Person AS o; -> syntax error
	// SELECT o FROM Person AS o; -> OK
	// it is the JPA specification, not a Toplink bug  
	public final static boolean USE_FULL_QUALIFIED_CLASSNAMES_IN_QUERY = false;


	protected SecurityManager securityManager=new SecurityManager();

	public BasicPersistenceController(String persistenceUnit) {
		super();
	}
	
	public void open(){
		EntityManager em= getThreadEntityManager();
		EntityTransaction tx=em.getTransaction();
		if(tx!=null && ! tx.isActive()){
		tx.begin();
		}
	}


//	public EntityManager getEntityManager() {
//		return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
//	}


	public void rollback(){
		EntityManager em = getThreadEntityManager();
		if (em != null) {
			EntityTransaction tx = null;
				tx = em.getTransaction();
				if (tx!=null && tx.isActive()) {
					tx.rollback();
				}
		}
	}
	
	public void commit() throws ControllerException{
		EntityManager em = getThreadEntityManager();
		if (em != null) {
			EntityTransaction tx = null;
			try {
				tx = em.getTransaction();
				if (tx!=null && tx.isActive()) {
					tx.commit();
				}
			} catch (PersistenceException e) {
				e.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();
				throw new ControllerException(e);
			} catch (IllegalStateException ise) {
				ise.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();
				throw new ControllerException(ise);
			} catch (Exception e) {
				e.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();
				throw new ControllerException(e);
			} 
		}
	}
	
	public synchronized void close()  {

		EntityManager em = getThreadEntityManager();
		
		// for open JPA it is required to   
		try {
			commit();
		} catch (ControllerException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (em != null) {
			em.close();
		}
//		if (emtl != null) {
//			emtl.remove();
//			// emtl=null;
//		}
		removeEntityManagerThreadLocal();
	}

	public SecurityManager getSecurityManager() {
		return securityManager;
	}

	public void setSecurityManager(SecurityManager securityManager) {
		this.securityManager = securityManager;
	}

}
