package ips.servlet.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ipsk.io.EditInputStream;
import ipsk.net.http.Utils;
import ipsk.text.StringTokenizer;

public class FileServer extends HttpServlet{
	protected final boolean DEBUG=false;

	private final static int DEF_BUF_SIZE=4096;

	private int bufSize=DEF_BUF_SIZE;

	private static final Charset ASCII_CHARSET=Charset.forName("US-ASCII");

	public class ByteRange{
		public ByteRange(long brStart, long brEnd) {
			super();
			this.start=brStart;
			this.end=brEnd;
		}
		private long start;
		public long getStart() {
			return start;
		}
		public long getEnd() {
			return end;
		}
		private long end;

		public long getLength(){
			return end-start+1;
		}
	}

	public void init() throws ServletException {
		super.init();
	}

	private void sendStream(File file,OutputStream out,long start,long length) throws IOException{
		FileInputStream fis=new FileInputStream(file);
		EditInputStream editInputStream=new EditInputStream(fis, start, length);
		try{
			byte[] buf=new byte[bufSize];
			int read=0;
			while((read=editInputStream.read(buf))!=-1){
				out.write(buf,0,read);
			}
		}catch(IOException e){
			throw e;
		}finally{
			try{
				if(editInputStream !=null) {
					editInputStream.close();
				}
			}catch(IOException e){

			}
		}
	}


	protected void serve(File file,String contentType,HttpServletRequest req,HttpServletResponse res)
			throws IOException {
		if(!file.exists()){
			throw new FileNotFoundException(file.getAbsolutePath()+ " not found");
		}
		long contentLength=file.length();
		if(contentType==null){
			ServletContext servletContext = getServletContext();
			contentType=servletContext.getMimeType(file.getAbsolutePath());
		}
		if(req!=null){

			// Check and parse range header
			String rangeStr=req.getHeader("Range");
			if(rangeStr!=null){
				List<ByteRange> byteRanges=new ArrayList<ByteRange>();
				long maxIdx=contentLength-1;
				rangeStr=rangeStr.trim();
				String unit;
				String valueStr;
				int ies=rangeStr.indexOf('=');
				if(ies>0){
					unit=rangeStr.substring(0,ies);
					// only accept unit bytes
					if("bytes".equals(unit)){
						valueStr=rangeStr.substring(ies+1);
						String[] brStrs=StringTokenizer.split(valueStr,',', true);
						int multiRangeContentLength=0;
						for(String brStr:brStrs){
							int brD=brStr.indexOf('-');
							if(brD>=0){
								long brStart=0;
								long brEnd=maxIdx;
								String brStartStr=brStr.substring(0, brD);
								String brEndStr=brStr.substring(brD+1);
								if(!"".equals(brStartStr)){
									brStart=Long.parseLong(brStartStr);
									if(brStart<0){
										brStart=0;
									}
								}
								if(!"".equals(brEndStr)){
									brEnd=Long.parseLong(brEndStr);
									if(brEnd>maxIdx){
										brEnd=maxIdx;
									}
								}
								ByteRange br=new ByteRange(brStart,brEnd);
								byteRanges.add(br);
								multiRangeContentLength+=br.getLength();
							}
						}
						if(byteRanges.size()>0){
							// deliver ranges
							if(byteRanges.size()==1){
								ByteRange br=byteRanges.get(0);
								long brLength=br.getLength();
								long brStart=br.getStart();
								long brEnd=br.getEnd();
								// Test if the range does not equal the whole file
								if(brStart!=0 || brLength!=contentLength){
									// Deliver the range
									res.setContentType(contentType);
									Utils.responseSetContentLength(res, brLength);
									String rangeHeader="bytes "+brStart+"-"+brEnd+"/"+contentLength;
									res.setHeader("Content-range", rangeHeader);
									res.setStatus(HttpServletResponse.SC_PARTIAL_CONTENT);
									OutputStream out=res.getOutputStream();
									sendStream(file, out,brStart , brLength);
									return;
								}
							}else{
								// multipart ranges

								// Use random UUID for parts boundary
								UUID uuid=UUID.randomUUID();

								String boundary=uuid.toString().replace('-', '_').substring(0,22);
								multiRangeContentLength+=((boundary.length()+2)*byteRanges.size());
								multiRangeContentLength+=(boundary.length()+2);
								//	res.setContentLength(multiRangeContentLength);
								res.setContentType("multipart/byteranges; boundary="+boundary);
								OutputStream out=res.getOutputStream();
								String rangeContentHeader="Content-Type: "+contentType;
								res.setStatus(HttpServletResponse.SC_PARTIAL_CONTENT);

								for(ByteRange br:byteRanges){
									long brStart=br.getStart();
									long brLength=br.getLength();
									StringBuffer sb=new StringBuffer();
									sb.append("\n--"+boundary+"\n");
									sb.append(rangeContentHeader+"\n");
									String rangeHeader="bytes "+br.getStart()+"-"+br.getEnd()+"/"+contentLength;
									sb.append("Content-range: "+rangeHeader+"\n\n");
									byte[] bb=sb.toString().getBytes(ASCII_CHARSET);
									out.write(bb);
									sendStream(file, out, brStart, brLength);
								}
								String fs=new String("\n--"+boundary+"--\n");
								out.write(fs.getBytes(ASCII_CHARSET));
								return;
							}
						}
					}else {
						// Only accept byte ranges
						res.setStatus(HttpServletResponse.SC_BAD_REQUEST);
					}
				}
			}else{
				// Only accept byte ranges
				res.setHeader("Accept-Ranges", "bytes");
			}
		}

		OutputStream out=res.getOutputStream();
		res.setContentType(contentType);
		Utils.responseSetContentLength(res, contentLength);
		FileInputStream fis=new FileInputStream(file);
		try{
			byte[] buf=new byte[bufSize];
			int read=0;
			while((read=fis.read(buf))!=-1){
				out.write(buf,0,read);
				out.flush();
			}
		}catch(IOException e){
			throw e;
		}finally{
			try{
				if(fis !=null)fis.close();
			}catch(IOException e){

			}
		}
	}
	protected void serve(File file,String contentType,HttpServletResponse res)
			throws IOException {
		serve(file,contentType,null,res);

	}
	protected void serve(File file,HttpServletResponse res)throws IOException {
		serve(file,null,res);
	}
}
