package ips.servlet.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.Part;

import ipsk.text.StringTokenizer;
import ipsk.text.quoting.QuoteParser;
import ipsk.text.quoting.TextPart;

public class MultipartUtils {

	
	public static String partFilename(Part part){
		
		//String filename=fPart.getSubmittedFileName(); // TODO Requires Servlet API 3.1.0 (Ubuntu 16.04 ?) 
		
		String filename=null;
		Collection<String> contentDispos=part.getHeaders("content-disposition");
		HashMap<String,List<String>> pMap=new HashMap<String, List<String>>();
		for(String cd:contentDispos){
			// parse quotes
			List<TextPart> textPartList=QuoteParser.parseText(cd,'"', '\\', false);
			// separate fields
			String[] fields=StringTokenizer.split(textPartList, ';', true);
			// first field is media type 

			// subsequent fields are parameters
			for(int i=1;i<fields.length;i++){
				String field=fields[i];
				int equInd=field.indexOf('=');
				if(equInd>0){
					// rfc2616: parameter names are case insensitive
					String key=field.substring(0, equInd).trim().toLowerCase(Locale.US);
					String val=field.substring(equInd+1).trim();
					List<String> paramVals=pMap.get(key);
					if(paramVals==null){
						paramVals=new ArrayList<String>();
						pMap.put(key,paramVals);
					}
					paramVals.add(val);
				}
			}
		}

		List<String> filenames=pMap.get("filename");
		if(filenames!=null && filenames.size()==1){
			String qtFilename=filenames.get(0);
			// Remove surrounding double quotes
			qtFilename=qtFilename.replaceAll("^\"","");
			filename=qtFilename.replaceAll("\"$","");

		}
		return filename;
	}
}
