package ips.servlet.http;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ParameterMapHttpServletRequestWrapper extends HttpServletRequestWrapper {

	private java.util.Map<java.lang.String,java.lang.String[]> parameterMap;
	
	public ParameterMapHttpServletRequestWrapper(HttpServletRequest request,java.util.Map<java.lang.String,java.lang.String[]> parameterMap) {
		super(request);
		this.parameterMap=parameterMap;
		
		
	}
	
	public String getParameter(String name){
		String[] vals= parameterMap.get(name);
		if(vals==null || vals.length==0){
			return null;
		}else{
			return vals[0];
		}
	}
	
	public java.util.Map<java.lang.String,java.lang.String[]> getParameterMap(){
		return parameterMap;
	}
	
	public java.util.Enumeration<java.lang.String> getParameterNames(){
		Hashtable<String, String[]> ht=new Hashtable<>(parameterMap);
		return ht.keys();
		
	}
	
	public java.lang.String[] getParameterValues(java.lang.String name){
		Collection<String[]> paramValsColl=parameterMap.values();
		int size=paramValsColl.size();
		return paramValsColl.toArray(new String[size]);
	}

}
