package ips.servlet.http;

import ipsk.text.StringSequenceBuilder;
import ipsk.text.html.HTMLTextEncoder;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

public class URLEncoder {
	public static String encodeURL(ServletRequest servletRequest,ServletResponse servletResponse,String url){
		String contextUrl=null;
		if(url.startsWith("/") && servletRequest!=null && servletRequest instanceof HttpServletRequest){
			contextUrl=((HttpServletRequest)servletRequest).getContextPath()+url;
		}else{
			contextUrl=url;
		}
		//String encodedUrl=HTMLTextEncoder.encode(contextUrl);
		if(servletResponse!=null && servletResponse instanceof HttpServletResponse){
			contextUrl=((HttpServletResponse)servletResponse).encodeURL(contextUrl);
		}
		return contextUrl;
	}
	public static String encodeURL(PageContext pageContext,String url){
		
		if(pageContext!=null){
			return encodeURL(pageContext.getRequest(),pageContext.getResponse(),url);
		}else{
			return encodeURL((ServletRequest)null,(ServletResponse)null,url);
		}
	}
	
	public static String parameterMapToQueryString(Map<String,String[]> parameterMap) {
		List<String> qStrs=new ArrayList<String>();
		Set<String> paramKeys=parameterMap.keySet();
		for(String pKey:paramKeys){
			String encKey;
			try {
				encKey = java.net.URLEncoder.encode(pKey, "UTF-8");
				String[] vals=parameterMap.get(pKey);
				for(String val:vals) {
					String encVal=java.net.URLEncoder.encode(val, "UTF-8");
					qStrs.add(encKey+"="+encVal);
				}
			} catch (UnsupportedEncodingException e) {
				// UTF-8 IS supported
				e.printStackTrace();
				return null;
			}
		}
		return StringSequenceBuilder.buildString(qStrs, '&');
	}
	
}
