package ipsk.jsp;


import java.util.List;

import ips.beans.ExtBeanInfo;
import ipsk.webapps.SelectMode;

public class BeanTableModel<E> {

	
	protected ExtBeanInfo extBeanInfo;
	
	protected List<? extends E> items;
	protected int itemCount;
	protected int firstItem;
	protected int lastItem;
	protected int batchSize;
	//protected int pageCount;
	protected Class<E> beanClass;
	
	//protected String action;
	
	protected Object[] selectedRowsIds;
	
	protected SelectMode selectMode=null;
	//protected boolean selectionMode;
	//protected boolean selectionMultiMode;
	//protected String selectCommand=null;
	
	protected Object[] selectedIds;
	
	//protected BasicController.RelatedQuery relatedquery=null;
	
	
	
//	/**
//	 * The class of the bean for which the bean requests a selection.
//	 */
//	protected String selectTargetClass;
	
	/**
	 * The ID property name of the bean for which the bean requests a selection.
	 */
	protected String selectTargetIdProperty;
	/**
	 * The ID value of the bean for which the bean requests a selection.
	 */
	protected String selectTargetId;

	//private PersistenceObjectIdentifier relatedObjectIdentifier;
	
	
	
	public int getBatchSize() {
		return batchSize;
	}
	
	public int getFirstItem() {
		return firstItem;
	}
	public int getItemCount() {
		return itemCount;
	}
	public List<? extends E> getItems() {
		return items;
	}
	public int getLastItem() {
		return lastItem;
	}
	public int getPage() {
			return firstItem / batchSize + 1;
	}
	public int getPageCount() {
		int pages = itemCount / batchSize;
		if (itemCount % batchSize > 0)
			pages+=1;
		return pages;
	}
	public void setBatchSize(int batchSize) {
		if(batchSize<=0) throw new IllegalArgumentException("Page batch size must be greater or equal one.");
		this.batchSize = batchSize;
	}
	
	public void setFirstItem(int firstItem) {
		this.firstItem = firstItem;
	}
	public void setItemCount(int itemCount) {
		this.itemCount = itemCount;
	}
	public void setItems(List<? extends E> items) {
		this.items = items;
	}
	
	public void notPageableItems(List<? extends E> items) {
		// set batch size to item count (or if item count 
		int itemCount=items.size();
		int batchSize=(itemCount>0)?itemCount:1;
		setBatchSize(batchSize);
		
		// fit values to one page
		setFirstItem(0);
		setLastItem(itemCount -1);
		setItemCount(itemCount);
		setItems(items);
	}
	
	public void setLastItem(int lastItem) {
		this.lastItem = lastItem;
	}
//	public Class getBeanClass() {
//		return beanClass;
//	}
//	public void setBeanClass(Class beanClass) {
//		this.beanClass = beanClass;
//	}

	public ExtBeanInfo getExtBeanInfo() {
		return extBeanInfo;
	}

	public void setExtBeanInfo(ExtBeanInfo extBeanInfo) {
		this.extBeanInfo = extBeanInfo;
	}

//	public boolean isSelectionMode() {
//		return selectionMode;
//	}
//
//	public void setSelectionMode(boolean selectionMode) {
//		this.selectionMode = selectionMode;
//	}

//	public void setSelectTargetClass(String selectTargetClass) {
//		this.selectTargetClass=selectTargetClass;
//	}
//	public String getSelectTargetClass(){
//		return selectTargetClass;
//	}
//	public String getSelectTargetProperty() {
//		return selectTargetProperty;
//	}
//
//	public void setSelectTargetProperty(String selectTargetProperty) {
//		this.selectTargetProperty = selectTargetProperty;
//	}

	public String getSelectTargetId() {
		return selectTargetId;
	}

	public void setSelectTargetId(String selectTargetId) {
		this.selectTargetId = selectTargetId;
	}

	public String getSelectTargetIdProperty() {
		return selectTargetIdProperty;
	}

	public void setSelectTargetIdProperty(String selectTargetIdProperty) {
		this.selectTargetIdProperty = selectTargetIdProperty;
	}

	public Object[] getSelectedIds() {
		return selectedIds;
	}

	public void setSelectedIds(Object[] selectedIds) {
		this.selectedIds = selectedIds;
	}

//	public String getAction() {
//		
//		return action;
//	}
//
//	public void setAction(String action) {
//		this.action = action;
//	}

//	public boolean isSelectionMultiMode() {
//		return selectionMultiMode;
//	}
//
//	public void setSelectionMultiMode(boolean selectionMultiMode) {
//		this.selectionMultiMode = selectionMultiMode;
//	}

//	public BasicController.RelatedQuery getRelatedquery() {
//		return relatedquery;
//	}
//
//	public void setRelatedquery(BasicController.RelatedQuery relatedquery) {
//		this.relatedquery = relatedquery;
//	}

//	public String getSelectCommand() {
//		return selectCommand;
//	}
//
//	public void setSelectCommand(String selectCommand) {
//		this.selectCommand = selectCommand;
//	}

	public SelectMode getSelectMode() {
		return selectMode;
	}

	public void setSelectMode(SelectMode selectMode) {
		this.selectMode = selectMode;
	}

	/**
	 * Get the ID's of bean objects whose corresponding rows should appear selected.
	 * @return
	 */
	public Object[] getSelectedRowsIds() {
		return selectedRowsIds;
	}
	/**
	 * Set the ID's of bean objects whose corresponding rows should appear selected.
	 * @return
	 */
	public void setSelectedRowsIds(Object[] selectedRowsIds) {
		this.selectedRowsIds = selectedRowsIds;
	}

	
	
	



}
