package ipsk.jsp.taglib;

import ipsk.beans.BeanModel;
import ipsk.beans.validation.ValidationResult;
import ipsk.jsp.BeanTableController;
import ipsk.jsp.Controller;
import ipsk.jsp.taglib.beans.BeanControllerProvider;
import ipsk.webapps.ProcessResult;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

/**
 * Tag for divisions enclosed by a controller tag. Displaying (executing) of the tag depends on the processing result of the page request.
 * It is intended to place editing forms, cancel response and error messages on one page.  
 * @author klausj
 *
 */
public class ControllerDivisionTag extends BeanTableControllerTag {

	
	private String result;
	
	
	public void setParent(Tag parent){
		super.setParent(parent);
		// Find enclosing bean controller provider
		Tag bpParent=parent;
		
		while(bpParent!=null && !(bpParent instanceof ControllerProvider)){
			bpParent=bpParent.getParent();
		}
		if(bpParent !=null && bpParent instanceof ControllerProvider){
			Controller scontroller=((ControllerProvider)bpParent).getController();
			if(scontroller instanceof BeanTableController){
				controller=(BeanTableController)scontroller;
			}
		}
		
	}
	public int doStartTag() throws JspException {
		ValidationResult validationResult=null;
		BeanModel beanModel=controller.getBeanModel();
		if(beanModel!=null){
		validationResult=beanModel.getValidationResult();
		}
//		if((vr==null && result==null)){
//		return EVAL_BODY_INCLUDE;
//		}else{
//			if(vr!=null){
//				if(vr.isValid() && result != null && result.equals("success")){
//				return EVAL_BODY_INCLUDE;
//				}else if(vr.isCancelled() && result !=null && result.equals("cancel")){
//					return EVAL_BODY_INCLUDE;
//				}else if(! vr.isValid() && ! vr.isCancelled() && result !=null && result.equals("error")){
//					// validation errors
//					return EVAL_BODY_INCLUDE;
//				}else if(! vr.isValid() && ! vr.isCancelled() && result==null){
//					// validation errors, present edit form again
//					return EVAL_BODY_INCLUDE;
//				}
//			}
//		}
//		
		ProcessResult processResult=controller.getProcessResult();
		if(processResult !=null && validationResult ==null){
			validationResult=processResult.getValidationResult();
		}
		if((processResult==null && result==null)){
			// no result of an action yet
			// present edit/view form
			return EVAL_BODY_INCLUDE;
		}else{
			if(processResult!=null){
				String resKey=processResult.getResultKey();
				if(resKey!=null && result !=null && result.equals(resKey)){
					return EVAL_BODY_INCLUDE;
				}else if(processResult.getType().equals(ProcessResult.Type.SUCCESS) && result != null && result.equals("success")){
					// success division tag (mostly action confirmation message)
					return EVAL_BODY_INCLUDE;
				}else if(processResult.getType().equals(ProcessResult.Type.CANCELLED) && result !=null && result.equals("cancel")){
					// cancel division tag
					return EVAL_BODY_INCLUDE;
				}else if(processResult.getType().equals(ProcessResult.Type.ERROR) && result !=null && result.equals("error")){
					// error division
					return EVAL_BODY_INCLUDE;
				}else if(processResult.getType().equals(ProcessResult.Type.ERROR) && result==null && validationResult!=null){
					// validation errors, present edit form again
					return EVAL_BODY_INCLUDE;
				}
			}
		}
		return SKIP_BODY;
	}

	public int doEndTag() throws JspException {
		return EVAL_PAGE;
	}

	public String getResult() {
		return result;
	}

	public void setResult(String result) {
		this.result = result;
	}

}
