package ipsk.jsp.taglib.beans;

import java.beans.PropertyDescriptor;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;



public class ActionTag extends BodyTagSupport {

	
	private BeanProvider beanProvider=null;

	private String name;
	
	public void setParent(Tag parent){
		super.setParent(parent);
		// Find enclosing bean provider tag
		Tag bpParent=parent;
		
		while(bpParent!=null && !(bpParent instanceof ipsk.jsp.taglib.beans.BeanProvider)){
			bpParent=bpParent.getParent();
		}
		if(bpParent !=null && bpParent instanceof ipsk.jsp.taglib.beans.BeanProvider){
			beanProvider=(BeanProvider)bpParent;
		}
	}
	
	
	public int doStartTag() throws JspException {
		PropertyDescriptor idPd=beanProvider.getBeanInfo().getIdPropertyDescriptor();
		return SKIP_BODY;
	}
	
	public int doEndTag() throws JspException {
		return EVAL_PAGE;
	}


	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}
	
}
