package ipsk.jsp.taglib.beans;

import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.text.html.HTMLTextEncoder;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;

public class BeanPropertyDescrTag extends ExtBodyTagSupport {

	protected BeanProperty beanProperty=null;
	
	public void setParent(Tag parent){
		Tag bpParent=parent;
		
		while(bpParent!=null && !(bpParent instanceof ipsk.jsp.taglib.beans.BeanPropertyProvider)){
			bpParent=bpParent.getParent();
		}
		if(bpParent !=null && bpParent instanceof ipsk.jsp.taglib.beans.BeanPropertyProvider){
			beanProperty=((ipsk.jsp.taglib.beans.BeanPropertyProvider)bpParent).getBeanProperty();
		}
	}
	
	
	public int doStartTag() throws JspException {	
//		Tag p=getParent();
//		BeanPropertyTag bpt=(BeanPropertyTag)p;
//		String descr=bpt.getBeanProperty().getDescriptor();
		String descr=beanProperty.getDescriptor();
		try{
			JspWriter w=pageContext.getOut();
			w.print(HTMLTextEncoder.encode(descr));
		}catch(Exception e){
			throw new JspException("Could not print bean property descriptor!",e);
		}
		return SKIP_BODY;
		
	}

	public int doEndTag() throws JspException {
		
		return EVAL_PAGE;
	}

	

}
