package ipsk.jsp.taglib.beans;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ips.servlet.http.URLEncoder;
import ipsk.beans.BeanModel;
import ipsk.beans.form.FormConfiguration;
import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.ParamConsumer;
import ipsk.net.EditableURI;
import ipsk.net.URLContext;
import ipsk.text.html.HTMLTextEncoder;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class BeanPropertyRelatedURLTag extends ExtBodyTagSupport implements BeanPropertyIterator,ParamConsumer{

	private String action;

	private String property;
	
	private Object bean;
	
	private BeanProperty beanProperty;
	
	private String var;

	public String getVar() {
		return var;
	}

	public void setVar(String var) {
		this.var = var;
	}

	private BeanPropertyProvider beanPropertyProvider;

	private BeanModel<Object> beanModel;

	private ExtBeanInfo beanInfo;
	
	private Map<String,String[]> params=new HashMap<>();

	public void setPageContext(PageContext pc) {
		super.setPageContext(pc);
		params.clear();
	}
	
	public void setParent(Tag parent){
		super.setParent(parent);
		// Find enclosing bean provider
		Tag bpParent=parent;
		
		while(bpParent!=null && !(bpParent instanceof BeanPropertyProvider)){
			bpParent=bpParent.getParent();
		}
		if(bpParent !=null && bpParent instanceof BeanPropertyProvider){
			beanPropertyProvider=(BeanPropertyProvider)bpParent;
		}
	}

	public int doStartTag() throws JspException {
		params.clear();
		return EVAL_BODY_INCLUDE;
	}
	

	public int doEndTag() throws JspException {
		RelationshipURL relURL=null;
		if(property!=null && bean !=null){
			beanProperty=new BeanProperty(property);
			beanModel=new BeanModel<Object>(bean);
			try {
				beanInfo = PersistenceIntrospector.getPersistenceBeanInfo(bean.getClass(),true);
				beanProperty.setContext(this);
				relURL=new RelationshipURL(beanProperty);
			} catch (Exception e1) {
				e1.printStackTrace();
				throw new JspException(e1);
			} 
		}else if(bean!=null){
			relURL=new RelationshipURL(bean);
		}else if(beanPropertyProvider!=null){

			// enclosing bean property provider
			beanProperty=beanPropertyProvider.getBeanProperty();
			relURL=new RelationshipURL(beanProperty);
		}else{
			throw new JspException("No bean found! Please set attribute 'bean'");
		}
		String uri=null;	
		try {
			
			EditableURI eUri=relURL.getEditableURI(action);
			eUri.appendQueryMap(params);
			uri=eUri.getUri();

		} catch (RelationshipException | UnsupportedEncodingException e) {
			e.printStackTrace();
			throw new JspException(e);
		}

		String encodedUrl=URLEncoder.encodeURL(pageContext,uri);
		String htmlEncodedURL=HTMLTextEncoder.encode(encodedUrl);
		if(var==null){
			try {
				JspWriter out=pageContext.getOut();
				out.print(htmlEncodedURL);
			} catch (IOException e) {
				e.printStackTrace();
				throw new JspException(e);
			}
		}else {
			pageContext.setAttribute(var,encodedUrl,
					PageContext.REQUEST_SCOPE);
		}

		return EVAL_PAGE;
	}

	

	public String getAction(){
		return action;
	}
	
	public void setAction(String action){
		this.action=action;
	}

	public String getProperty() {
		return property;
	}

	public void setProperty(String property) {
		this.property = property;
	}

	public Object getBean() {
		return bean;
	}

	public void setBean(Object bean) {
		this.bean = bean;
	}

	public String getActionCommand() {
		return null;
	}

	public String[] getAdditionalPropertyNames() {
		
		return null;
	}

	public BeanModel getBeanModel() {
		return beanModel;
	}

	public String getCurrentProperty() {
		return property;
	}

	public PageContext getPageContext() {
		
		return pageContext;
	}

	public void setCurrentPropertyDone(boolean b) {
		// OK
	}

	public ExtBeanInfo getBeanInfo() {
		return beanInfo;
	}

	public FormConfiguration getFormConfiguration() {
		// TODO Auto-generated method stub
		return null;
	}

	public Iteration getIteration() {
		return Iteration.TABLE;
	}

	@Override
	public void applyParam(String name, String value) {
		String[] vals=params.get(name);
		String[] newVals=null;
		if(vals==null) {
			newVals=new String[] {value};
		}else {
			int valsLen=vals.length;
			newVals=Arrays.copyOf(vals,valsLen+1);
			newVals[valsLen]=value;
		}
		params.put(name, newVals);
	}

}
