package ipsk.jsp.taglib.beans;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.beans.BeanModel;
import ipsk.beans.PropertyNameOrder;
import ipsk.beans.form.FormConfiguration;
import ipsk.beans.form.PropertyConfiguration;
import ipsk.jsp.BeanTableController;
import ipsk.jsp.Controller;
import ipsk.jsp.taglib.ControllerProvider;
import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.ProcessResult;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

import javax.persistence.Transient;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public abstract class BeanProviderTag extends ExtBodyTagSupport implements
		BeanProvider, BeanPropertyIterator{


	
	private BeanModel<Object> beanModel;

	protected ExtBeanInfo beanInfo = null;

	protected String beanIdPropertyVar;
	protected String beanIdVar;
	// private String resourceBundleName = null;

	private String props = null;
	
	private String requiredProps=null;
	
	private Iteration iteration=Iteration.TABLE;

	// protected PropertyDescriptor idPropertyDescriptor = null;

	public Iteration getIteration() {
		return iteration;
	}


	public String getRequiredProps() {
		return requiredProps;
	}


	public void setRequiredProps(String requiredProps) {
		this.requiredProps = requiredProps;
	}

	protected Object idValue = null;

	protected ArrayList<String> displayedProps = null;

	protected String currentProperty = null;

	protected boolean currentPropertyDone = false;

	protected int propertyPosition = 0;

	protected boolean idGenerated = false;

	protected String[] preferredDisplayOrder = null;

	protected LocalizableMessage validationMessage;
	
	protected BeanTableController controller;
	
	private String additionalProps = null;
	private String[] additionalPropertyNames;
	
	public ExtBeanInfo getBeanInfo() {
		return beanInfo;
	}

	
	public void setParent(Tag parent){
		super.setParent(parent);
		// Find enclosing bean controller provider
		Tag bpParent=parent;
		
		while(bpParent!=null && !(bpParent instanceof ControllerProvider)){
			bpParent=bpParent.getParent();
		}
		if(bpParent !=null && bpParent instanceof ControllerProvider){
			Controller scontroller=((ControllerProvider)bpParent).getController();
			if(scontroller instanceof BeanTableController){
				controller=(BeanTableController)scontroller;
			}
			beanInfo=controller.getBeanInfo();
		}
	}
	
	public int doStartTag() throws JspException {
		iteration=Iteration.TABLE;
		List<String> reqProps=new ArrayList<String>();
		if(requiredProps!=null){
			reqProps=PropertyNameOrder.parsePropertyListAsList(requiredProps);
		}
		FormConfiguration config=getFormConfiguration();
		if(config!=null){
			displayedProps=new ArrayList<String>();
			
//			boolean defaultShow=config.isDefaultShow();
			List<PropertyConfiguration> propCfgSet=config.getPropertyConfigurations();
			if(propCfgSet!=null){
//				Set<String> propNamesToRemove=new HashSet<String>();
				
					for(PropertyConfiguration pc:propCfgSet){
						PropertyDescriptor pd=pc.getPropertyDescriptor();
						String pdName=pd.getName();
						displayedProps.add(pdName);
					}
				
				
			}
			displayedProps.addAll(reqProps);
		}else{
			// bean info seems to return immutable set
			Set<String> propertyNames=new HashSet<String>(beanInfo.getPersistencePropertyNames());
			if(additionalPropertyNames!=null) {
				Set<String> additionalPropertyNamesSet= Set.of(additionalPropertyNames);
				propertyNames.addAll(additionalPropertyNamesSet);
			}
			PropertyNameOrder pno=new PropertyNameOrder(propertyNames);
			pno.applyPreferredOrder(beanInfo.getPreferredDisplayOrder());

			if (props != null) {
				pno.applyPreferredOrder(props);
			}
			List<String> opList=pno.getOrderArrayList();
			if(reqProps!=null){
				for(String reProp:reqProps){
					if(!opList.contains(reProp)){
						opList.add(reProp);
					}
				}
			}
			String[] ordArr=pno.getOrder();
			displayedProps=new ArrayList<String>();
			displayedProps.addAll(Arrays.asList(ordArr));
			
			displayedProps.removeAll(beanInfo.getHiddenProperties());
		}
//			displayedProps = new ArrayList<String>();
//			int asteriskInsertPoint = -1;
//			StringTokenizer st = new StringTokenizer(props, ",");
//			while (st.hasMoreTokens()) {
//				String ttoken = st.nextToken().trim();
//				if (ttoken.equals("*")) {
//					asteriskInsertPoint = displayedProps.size();
//				} else {
//					displayedProps.add(ttoken);
//				}
//			}
//
//			ArrayList<String> unsortedProps = new ArrayList<String>();
//			try {
//				idValue = beanInfo.getIdValue(bean);
//			} catch (Exception e) {
//				e.printStackTrace();
//				throw new JspException("Could not read bean ID", e);
//			}
//			
//			for (PropertyDescriptor pd : beanInfo.getPersistencePropertyDescriptors()) {
//				String pdName = pd.getName();
//				Class type = pd.getPropertyType();
//				Method rm = pd.getReadMethod();
//				// if (rm.getAnnotation(javax.persistence.Id.class) != null ||
//				// rm.getAnnotation(javax.persistence.EmbeddedId.class) != null)
//				// {
//				// idPropertyDescriptor = pd;
//				// try {
//				// idValue = rm.invoke(bean, new Object[0]);
//				// } catch (Exception e) {
//				// e.printStackTrace();
//				// throw new JspException("Could not read bean ID", e);
//				// }
//				// }
//				// if (rm.getAnnotation(javax.persistence.GeneratedValue.class)
//				// != null) {
//				// setIdGenerated(true);
//				// }
//				
//				
//				if (asteriskInsertPoint >= 0) {
//					// && !Collection.class.isAssignableFrom(type)) {
//					// rest of properties (unsorted for now
//					if (!displayedProps.contains(pdName)) {
//						unsortedProps.add(pdName);
//					}
//				}
//			}
//
//			if (asteriskInsertPoint >= 0) {
//
//				String[] prefProporder = beanInfo.getPreferredDisplayOrder();
//				if (prefProporder != null) {
//					// if the bean has a preferred order for the properties:
//					int asteriskPrefInsertPoint = -1;
//					ArrayList<String> prefDisplayedProps = new ArrayList<String>();
//					for (String prefProp : prefProporder) {
//
//						// preferred order can also have one asterisk
//						if (prefProp.equals("*")) {
//							asteriskPrefInsertPoint = prefDisplayedProps.size();
//						} else {
//							if (unsortedProps.contains(prefProp)) {
//								prefDisplayedProps.add(prefProp);
//								unsortedProps.remove(prefProp);
//							}
//						}
//					}
//
//					if (asteriskPrefInsertPoint >= 0) {
//						prefDisplayedProps.addAll(asteriskPrefInsertPoint,
//								unsortedProps);
//					}
//					displayedProps.addAll(asteriskInsertPoint,
//							prefDisplayedProps);
//				} else {
//					// no preferred bean property order
//					displayedProps.addAll(asteriskInsertPoint, unsortedProps);
//				}
//			}
//			currentPropertyDone = false;

		currentPropertyDone = false;
//			displayedProps=pno.getOrderArrayList();
		
			if (displayedProps.size() > 0) {
				propertyPosition = 0;
				currentProperty = displayedProps.get(propertyPosition);
			}
//		} else {
//			displayedProps = null;
//		}

		return EVAL_BODY_INCLUDE;
	}

	protected boolean nextProperty() {
		if (displayedProps != null && currentProperty != null) {
			propertyPosition++;
			if (propertyPosition >= displayedProps.size()) {
				currentProperty = null;
			} else {
				currentProperty = displayedProps.get(propertyPosition);
			}
		}
		if (currentProperty != null) {
			setCurrentPropertyDone(false);
			return true;
		} else {
			if(Iteration.TABLE.equals(iteration)){
				propertyPosition=0;
				if (propertyPosition >= displayedProps.size()) {
					currentProperty = null;
					return false;
				} else {
					currentProperty = displayedProps.get(propertyPosition);
					iteration=Iteration.HIDDEN;
					return nextProperty();
				}
			}else{
				return false;
			}
		}
	}
	
	public int doAfterBody() throws JspException {
		boolean hasNextproperty=nextProperty();
		if(hasNextproperty){
			return EVAL_BODY_AGAIN;
		}else{
			return SKIP_BODY;
		}
	}

	public int doEndTag() throws JspException {
		return EVAL_PAGE;
	}

//	public Object getBean() {
//		if(beanModel==null){
//			if(controller!=null){
//				beanModel=controller.getBeanModel();
//			}
//		}
//		return beanModel.getBean();
//	}

	public void setBean(Object bean) {
		// TODO catch null beans
		beanModel=new BeanModel<Object>(bean);
		try {
			beanInfo = PersistenceIntrospector.getExtendedBeanInfo(bean
					.getClass());
			
		} catch (IntrospectionException e) {	
			e.printStackTrace();
			return;
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
			return;
		}
		setVars();
		if(controller!=null){
			ProcessResult pr=controller.getProcessResult();
			if(pr!=null){
				beanModel.setValidationResult(pr.getValidationResult());
			}
		}
	}
	
	private void setVars(){
		if(beanModel!=null){
		if (beanIdPropertyVar != null) {
			getPageContext().setAttribute(beanIdPropertyVar, beanInfo.getIdPropertyDescriptor().getName(),
					PageContext.REQUEST_SCOPE);
		}
		if (beanIdVar != null) {
			try {
				getPageContext().setAttribute(beanIdVar, beanInfo.getIdValue(beanModel.getBean()),
						PageContext.REQUEST_SCOPE);
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		}
	}
	
	
	
	

	public String getProps() {
		return props;
	}

	public void setProps(String props) {
		this.props = props;
	}
	
	public String getAdditionalProps() {
		return additionalProps;
	}

	public void setAdditionalProps(String additionalProps) {
		this.additionalProps = additionalProps;
		
		StringTokenizer addPropsTokenizer = new StringTokenizer(additionalProps,
				",");
		int c = addPropsTokenizer.countTokens();
		additionalPropertyNames = new String[c];
		for (int i = 0; i < c; i++) {
			additionalPropertyNames[i] = addPropsTokenizer.nextToken().trim();
		}
		if(additionalPropertyNames!=null){
//			for(String addColName:additionalPropsArr){
//				BeanTableCol btct = new BeanTableCol(addColName);
//				
//				//colTags.put(addColName, btct);
//			}
		}
	}

	// public String getResourceBundleName() {
	// return resourceBundleName;
	// }

	public String getCurrentProperty() {
		return currentProperty;
	}

	public void setCurrentPropertyDone(boolean b) {
		currentPropertyDone = b;

	}

	public PageContext getPageContext() {

		return pageContext;
	}

	//
	// public PropertyDescriptor getIdPropertyDescriptor() {
	// return idPropertyDescriptor;
	// }
	//
	// public boolean isIdGenerated() {
	// return idGenerated;
	// }
	//
	// public void setIdGenerated(boolean idGenerated) {
	// this.idGenerated = idGenerated;
	// }
	//
	// public String[] getPreferredDisplayOrder() {
	// return preferredDisplayOrder;
	// }
	//
	// public void setPreferredDisplayOrder(String[] preferredDisplayOrder) {
	// this.preferredDisplayOrder = preferredDisplayOrder;
	// }

	public abstract String getActionCommand();

	public String getBeanIdPropertyVar() {
		return beanIdPropertyVar;
	}

	public void setBeanIdPropertyVar(String beanIdPropertyVar) {
		this.beanIdPropertyVar = beanIdPropertyVar;
		setVars();
	}

	public String getBeanIdVar() {
		return beanIdVar;
	}

	public void setBeanIdVar(String beanIdVar) {
		this.beanIdVar = beanIdVar;
		setVars();
	}

	public BeanModel getBeanModel() {
		if(beanModel !=null){
			return beanModel;
		}else{
			return controller.getBeanModel();
		}
	}


	public String[] getAdditionalPropertyNames() {
		return additionalPropertyNames;
	}
	
	public FormConfiguration getFormConfiguration(){
		if(controller!=null){
			return controller.getFormConfiguration();
		}
		return null;
		
	}

}
