package ipsk.jsp.taglib.beans.edit;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

import ipsk.beans.BeanModel;
import ipsk.beans.validation.ValidationResult;
import ipsk.jsp.taglib.beans.BeanPropertySecureTokenTag;
import ipsk.jsp.taglib.beans.BeanProviderTag;
import ipsk.text.html.HTMLTextEncoder;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.SecureRequestTokenProvider;

public class BeanFormTag extends BeanProviderTag {

	private String action;
	private String actionCommand;
	private String submitText;
	private String cancelText;
	private boolean showResetButton=true;
	
	private String tableClass;
	private String tableClassAttr="";
	private boolean hasBody=false;
	private boolean tableEndPrinted=false;
	private Set<String> hiddenProperties=null;

	
	public int doStartTag() throws JspException {
		super.doStartTag();

		if(displayedProps!=null){
			PropertyDescriptor idPd=beanInfo.getIdPropertyDescriptor();
			if(idPd!=null){
				String idPdName=idPd.getName();
				if(actionCommand.equals(BasicPersistenceBeanController.CMD_STORE) && !displayedProps.contains(idPdName)){
					
					displayedProps.add(0,idPdName);
				}
				if(beanInfo.isIdGenerated() && actionCommand.equals(BasicPersistenceBeanController.CMD_ADD)){
					// if this is a new request and the ID is generated by the database remove the ID property
					// from displayed property list
					displayedProps.remove(idPdName);
				}
			}
		}
		// get current property again
		currentProperty=null;
		validationMessage=null;
		if (displayedProps.size() > 0) {
			propertyPosition = 0;
			currentProperty = displayedProps.get(propertyPosition);
		}
		JspWriter w = pageContext.getOut();
		String hrefAction;
		if(action!=null){
			hrefAction=action;
		}else{
		HttpServletRequest req=(HttpServletRequest)pageContext.getRequest();
		hrefAction=req.getRequestURL().toString();
		}
		tableEndPrinted=false;
		try {
			w.println("<form method=\"POST\" action=\""+encodeURL(hrefAction)+"\" accept-charset=\"UTF-8\" enctype=\"application/x-www-form-urlencoded;charset=utf-8\">");
			ServletRequest sReq=pageContext.getRequest();
			if(sReq instanceof HttpServletRequest) {
				HttpServletRequest req=(HttpServletRequest)sReq;
				String sie=BeanPropertySecureTokenTag.secureRequestTokenInputElement(req);
				w.println(sie);
			}
			w.println("<table"+tableClassAttr+">");
		} catch (IOException e) {
			throw new JspException(e);
		}
		hiddenProperties=new HashSet<String>();
		hasBody=false;
		return EVAL_BODY_INCLUDE;
	}
	
	public int doAfterBody() throws JspException {
		hasBody=true;
		return printProperties();
	}
	public int printProperties() throws JspException {
		//JspWriter w=pageContext.getOut();
		
		Iteration it=getIteration();
		if(Iteration.TABLE.equals(it)){
		if (currentProperty !=null && !currentPropertyDone){
			BeanPropertyTag bpt=new BeanPropertyTag();
			
			try {
				bpt.setPageContext(pageContext);
				bpt.setParent(this);
				bpt.getBeanProperty().setContext(this);
				bpt.printTag();
			} catch (Exception e) {
				e.printStackTrace();
				throw new JspException(e);
			}
			setCurrentPropertyDone(true);
			
		}
		}else if(Iteration.HIDDEN.equals(it)){
			if(!tableEndPrinted){
				JspWriter w = pageContext.getOut();
				try {
					w.println("</table>");
				} catch (IOException e) {
					e.printStackTrace();
					throw new JspException(e);
					
				}
				tableEndPrinted=true;
			}
		}
		return super.doAfterBody();
	}

	public int doEndTag() throws JspException {
		JspWriter w = pageContext.getOut();
		try {
			if(!hasBody){
				int res;
				do{
					res=printProperties();
				}while(res==EVAL_BODY_AGAIN);
			}
			if(!tableEndPrinted){
				w.println("</table>");
			}
			
			// print validation result message
			BeanModel<?> bm=getBeanModel();
			if(bm!=null) {
				ValidationResult vr=bm.getValidationResult();
				if(vr!=null) {
					LocalizableMessage vm=vr.getMessage();
					if(vm!=null) {
						String locValidationMsg=getLocalizedMessage(vm);
						String locVmHtml=HTMLTextEncoder.encode(locValidationMsg);
						w.println("<p class=\"warn\">"+locVmHtml+"</p>");
					}
				}
			}
			String submitValue;
			if(submitText!=null && !"".equals(submitText)) {
				submitValue=HTMLTextEncoder.encode(submitText);
			}else {
				submitValue=getLocalizedMessage("save");
			}

			String cancelValue;
			if(cancelText!=null && !"".equals(cancelText)) {
				cancelValue=HTMLTextEncoder.encode(cancelText);
			}else {
				cancelValue=getLocalizedMessage("cancel");
			}

			w.print("<input type=\"submit\" name=\"_"+actionCommand+"\" value=\""+submitValue+"\"/>");
			w.print("<input type=\"submit\" name=\"_"+BasicPersistenceBeanController.CMD_CANCEL+"\" value=\""+cancelValue+"\"/>");
			if(showResetButton) {
				w.println("<input type=\"reset\" name=\"_"+BasicPersistenceBeanController.CMD_CANCEL+"\" value=\""+getLocalizedMessage("reset")+"\"/>");
			}
			w.println("</form>");
			
		} catch (IOException e) {
			throw new JspException(e);
		}
		return EVAL_PAGE;
	}

	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public String getActionCommand() {
		return actionCommand;
	}

	public void setActionCommand(String actionCommand) {
		this.actionCommand = actionCommand;
	}
	
	public String getSubmitText() {
		return submitText;
	}

	public void setSubmitText(String submitText) {
		this.submitText = submitText;
	}

	public String getCancelText() {
		return cancelText;
	}

	public void setCancelText(String cancelText) {
		this.cancelText = cancelText;
	}

	public boolean isShowResetButton() {
		return showResetButton;
	}

	public void setShowResetButton(boolean showResetButton) {
		this.showResetButton = showResetButton;
	}


	public String getBeanIdPropertyVar() {
		return beanIdPropertyVar;
	}

	public void setBeanIdPropertyVar(String beanIdPropertyVar) {
		this.beanIdPropertyVar = beanIdPropertyVar;
	}

	public String getTableClass() {
		return tableClass;
	}

	public void setTableClass(String tableClass) {
		this.tableClass = tableClass;
		tableClassAttr=" class=\""+tableClass+"\"";
	}


}
