package ipsk.jsp.taglib.beans.table;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;

import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.beans.BeanProperty;
import ipsk.jsp.taglib.beans.BeanPropertyTag;
import ipsk.jsp.taglib.beans.BeanPropertyTagUtils;

public class BeanPropertyDescrDataCellTag extends ExtBodyTagSupport{

	protected BeanProperty beanProperty=null;
	
	public void setParent(Tag parent){
		Tag bpParent=parent;
		
		while(bpParent!=null && !(bpParent instanceof ipsk.jsp.taglib.beans.BeanPropertyProvider)){
			bpParent=bpParent.getParent();
		}
		if(bpParent !=null && bpParent instanceof ipsk.jsp.taglib.beans.BeanPropertyProvider){
			beanProperty=((ipsk.jsp.taglib.beans.BeanPropertyProvider)bpParent).getBeanProperty();
		}
	}
	
	public int doStartTag() throws JspException {	
		String titleHtmlTooltipAttributeStr=descriptorHtmlTitelTooltipAttribute();
		String descrTdHtml="<td"+titleHtmlTooltipAttributeStr+">";
		JspWriter w=pageContext.getOut();
		try {
			w.print(descrTdHtml);
		} catch (IOException e) {
			throw new JspException("Could not print bean property descriptor start tag!",e);
		}
		return SKIP_BODY;
	}
	
	public int doEndTag() throws JspException {
		try{
			JspWriter w=pageContext.getOut();
			String descrHtml=descriptorHtml();
			if(descrHtml!=null) {
				w.print(descrHtml);
			}
			w.print("</td>");
		}catch(Exception e){
			throw new JspException("Could not print bean property end descriptor!",e);
		}
		return EVAL_PAGE;
	}

	public String descriptorHtmlTitelTooltipAttribute() {
		return BeanPropertyTagUtils.descriptorHtmlTitelTooltipAttribute(beanProperty);
	}

	public String descriptorHtml() {
		return BeanPropertyTagUtils.descriptorHtml(beanProperty);
	}
	
}
