package ipsk.jsp.taglib.beans.table;

import ips.beans.ExtBeanInfo;
import ipsk.jsp.BeanTableController;
import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.beans.BeanControllerProvider;
import ipsk.text.html.HTMLTextEncoder;
import ipsk.webapps.BasicPersistenceBeanController;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.Tag;

public class BeanTableCustomizeTag extends ExtBodyTagSupport {

	private BeanTableController controller;

	private BeanTableTag beanTable;

	//private BeanTableModel beanTableModel;

	public void setParent(Tag parent) {
		if (parent instanceof BeanControllerProvider) {
			controller = ((BeanControllerProvider) parent).getController();
			//beanTableModel = controller.getBeanTableModel();
		}
		if (parent instanceof BeanTableTag) {
			beanTable = (BeanTableTag) parent;
		}
	}

	public int doStartTag() throws JspException {
		return EVAL_BODY_INCLUDE;
	}

	public int doEndTag() throws JspException {
		if(beanTable.getRowStatus()==BeanTableTag.RowStatus.CUSTOMIZER){
			ExtBeanInfo beanInfo=controller.getBeanInfo();
			List<String> hiddenProps=beanInfo.getHiddenProperties();
		PropertyDescriptor[] pds = beanInfo.getPersistencePropertyDescriptors();
		List<String> dps = beanTable.getDisplayColumns();
		List<String> hiddenCols = new ArrayList<String>();
		List<String> shownCols = new ArrayList<String>();
		List<String> availCols=new ArrayList<String>();
		for (PropertyDescriptor pd : pds) {
			String pdName=pd.getName();
			
			availCols.add(pdName);
		}
		String[] addCols=beanTable.getAdditionalColsArr();
		if(addCols!=null){
			for(String addColname:addCols){
				availCols.add(addColname);
			}
		}
				
		availCols.removeAll(hiddenProps);
		
		for(String pdName:availCols){
			boolean shown = false;
			for (String dp : dps) {
				if (dp.equals(pdName)) {
					shownCols.add(pdName);
					shown = true;
					break;
				}
			}
			if (!shown) {
				hiddenCols.add(pdName);
			}
		}

		HttpServletRequest req = (HttpServletRequest) (pageContext.getRequest());
		
		String servletPath = req.getServletPath();
		JspWriter ow = pageContext.getOut();

		try {
			ow.println("<table><tr>");
			ow
					.println("<td><form method=\"POST\" action=\""
							+ encodeURL(servletPath)
							+ "\" accept-charset=\"UTF-8\" enctype=\"application/x-www-form-urlencoded;charset=utf-8\">");

			ow.println("<select name=\"_col\">");
			ow
					.println("<option value=\"\" selected >-- "+getLocalizedMessage("column.add")+" --</option>");
			for (String hcName : hiddenCols) {
				String name=hcName;
//				String pDescr=name;
//				PropertyDescriptor pd=beanInfo.getPersistencePropertyDescriptor(hcName);
//				if(pd!=null){
//					name=pd.getName();
//					pDescr = pd.getShortDescription();
//					String resKey = (String) pd
//					.getValue(ipsk.util.ResourceKey.class.getName());
//					if (resKey != null) {
//						pDescr = LocaleSupport.getLocalizedMessage(pageContext,
//								resKey, controller.getBeanInfo()
//								.getResourceBundleName());
//					}
//
//				}
				String pDescr=beanTable.getColHeader(hcName);
				ow.println("<option value=\"" + name + "\">" + HTMLTextEncoder.encode(pDescr)
						+ "</option>");
			}

			ow.println("</select>");
			ow.println("<input type=\"hidden\" name=\""
					+ BasicPersistenceBeanController.KEY_CMD + "\" value=\""
					+ BasicPersistenceBeanController.CMD_LIST_ADD_COL + "\" />");
			ow
					.println("<input type=\"submit\" name=\"_submit\" value=\""+getLocalizedMessage("column.add")+"\" />");
			ow.print("</form></td>");

			ow
					.println("<td><form method=\"POST\" action=\""
							+ encodeURL(servletPath)
							+ "\" accept-charset=\"UTF-8\" enctype=\"application/x-www-form-urlencoded;charset=utf-8\">");

			ow.println("<select name=\"_col\">");
			ow
					.println("<option value=\"\" selected >-- "+getLocalizedMessage("column.remove")+" --</option>");
			for (String shownColName : shownCols) {
				String name=shownColName;
//				String pDescr=name;
//				PropertyDescriptor pd=beanInfo.getPersistencePropertyDescriptor(shownColName);
//				if(pd!=null){
//					pDescr = pd.getShortDescription();
//					String resKey = (String) pd
//					.getValue(ipsk.util.ResourceKey.class.getName());
//					if (resKey != null) {
//						pDescr = LocaleSupport.getLocalizedMessage(pageContext,
//								resKey, controller.getBeanInfo()
//								.getResourceBundleName());
//					}
//				}
				String pDescr=beanTable.getColHeader(shownColName);
				ow.println("<option value=\"" + name + "\">" + HTMLTextEncoder.encode(pDescr)
						+ "</option>");
			}

			ow.println("</select>");
			ow.println("<input type=\"hidden\" name=\""
					+ BasicPersistenceBeanController.KEY_CMD + "\" value=\""
					+ BasicPersistenceBeanController.CMD_LIST_REMOVE_COL + "\" />");
			ow
					.println("<input type=\"submit\" name=\"_submit\" value=\""+getLocalizedMessage("column.remove")+"\" />");
			ow.print("</form></td>");
			ow
			.println("<td><form method=\"POST\" action=\""
					+ encodeURL(servletPath)
					+ "\" accept-charset=\"UTF-8\" enctype=\"application/x-www-form-urlencoded;charset=utf-8\">");

	ow.println("<input type=\"hidden\" name=\""
			+ BasicPersistenceBeanController.KEY_CMD + "\" value=\""
			+ BasicPersistenceBeanController.CMD_LIST_COLS_RESET + "\" />");
	ow
			.println("<input type=\"submit\" name=\"_submit\" value=\""+getLocalizedMessage("reset")+"\" />");
	ow.println("</form></td>");
	ow.println("</tr></table>");
		} catch (IOException ioe) {
			throw new JspException("Error: IOException while writing tabel customizer");
		}
		}
		return EVAL_PAGE;
	}

}
