package ipsk.jsp.taglib.beans.table;

import java.util.Map;

import javax.servlet.jsp.tagext.BodyContent;

import ipsk.webapps.BasicPersistenceBeanController;


public class BeanTableRowAction{
	
	public static final String DEFAULT_BUNDLE_NAME="ipsk.jsp.Messages";
	
	public static final String VIEW_ACTION="view";
	public static final String EDIT_ACTION="edit";
	public static final String SELECT_ACTION="select";
	public static final String REMOVE_ACTION = "remove";
	public static final String REMOVE_REQUEST_ACTION = "remove_request";
	public static final String DELETE_ACTION = "delete";
	public static final String DELETE_REQUEST_ACTION = "delete_request";
	public static final String EXPORT_ACTION = "export";
	
	private String bundle=null;
	private String name;
	private String href;
	private String hrefURL;
	private Map<String,String> classSimpleNameHrefMap=null;

	private String bodyContentStr;
	
	

	public BeanTableRowAction(String bundle,String name,String href,String hrefURL,Map<String,String> classHrefMap){
		super();
		this.bundle=bundle;
		this.name=name;
		this.href=href;
		this.hrefURL=hrefURL;
		this.classSimpleNameHrefMap=classHrefMap;
		this.bodyContentStr=null;
	}
	
	public void setBodyContentStr(String bodyContentStr) {
		this.bodyContentStr = bodyContentStr;
	}

	public String getBodyContentStr() {
		return bodyContentStr;
	}
	
	public String getHrefURL() {
		return hrefURL;
	}

	public void setHrefURL(String hrefURL) {
		this.hrefURL = hrefURL;
	}


	public String getBundle() {
		return bundle;
	}

	public void setBundle(String bundle) {
		this.bundle = bundle;
	}
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getHref() {
		return href;
	}

	public void setHref(String action) {
		this.href = action;
	}
	
	public Map<String, String> getClassSimpleNameHrefMap() {
		return classSimpleNameHrefMap;
	}

	public void setClassSimpleNameHrefMap(Map<String, String> classHrefMap) {
		this.classSimpleNameHrefMap = classHrefMap;
	}
	
	public String getControllerCommand(){
		if(name.equals(SELECT_ACTION)){
			return BasicPersistenceBeanController.CMD_LIST_SELECT_ITEM;
		}else if(name.equals(DELETE_REQUEST_ACTION)){
			return BasicPersistenceBeanController.CMD_VIEW;
		}else if(name.equals(REMOVE_REQUEST_ACTION)){
			return BasicPersistenceBeanController.CMD_VIEW;
		}else if(name.equals(EXPORT_ACTION)){
			return BasicPersistenceBeanController.CMD_VIEW;
		}else return name;
	}
	
	public String getResourceBundle(){
		if(bundle==null || "".equals(bundle)){
			return DEFAULT_BUNDLE_NAME;
		}else{
			return bundle;
		}
	}
	
	public String getResourceKey(){
		if(name.equals(DELETE_REQUEST_ACTION) || name.equals(REMOVE_REQUEST_ACTION)){
			return "delete";
		}else return name;
	}
	
	public boolean isImmediately() {
		if(name.equals(DELETE_REQUEST_ACTION) || name.equals(REMOVE_REQUEST_ACTION)){
			return false;
		}else return true;
	}
	
	public boolean isRemoving(){
		String actionName=getName();
		return (BeanTableRowAction.REMOVE_REQUEST_ACTION.equals(actionName) || BeanTableRowAction.REMOVE_ACTION.equals(actionName) ||
				BeanTableRowAction.DELETE_REQUEST_ACTION.equals(actionName) || BeanTableRowAction.DELETE_ACTION.equals(actionName));
	}
	
	public boolean isModifying(){
		String actionName=getName();
		return (isRemoving() || BeanTableRowAction.EDIT_ACTION.equals(actionName));
	}

	
}
