package ipsk.jsp.taglib.beans.table;

import ipsk.jsp.taglib.ExtBodyTagSupport;
import java.util.List;
import java.util.Map;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.Tag;

public class BeanTableRowActionTag extends ExtBodyTagSupport {

	private String bundle=null;
	private String name=null;
	private String href;
	private String hrefURL;
	private Map<String,String> classSimpleNameHrefMap=null;

	public String objIdentStr() {
	     return this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this));
	}
	
	public String getHrefURL() {
		return hrefURL;
	}

	public void setHrefURL(String hrefURL) {
		this.hrefURL = hrefURL;
	}

	private BeanTableTag beanTable;
	
	private BeanTableRowAction rowAction() throws JspException {
		List<BeanTableRowAction> actions=beanTable.getRowActions();
		
		BeanTableRowAction btra=null;
		for(BeanTableRowAction a:actions) {
			if(name!=null && name.equals(a.getName())){
				if(btra!=null) {
					throw new JspException("Duplicate attribute name (\""+name+"\") for table row action (tag element \"btrowaction\" not allowed");
				}else {
					btra=a;
				}
			}
		}
		
		if(btra==null) {
			throw new JspException("Row action \""+name+"\" not found.");
		}
		return btra;
	}

	public void setParent(Tag parent) {
		super.setParent(parent);
		if (parent instanceof BeanTableTag) {
			beanTable = (BeanTableTag) parent;
		}
	}
	
	public int doStartTag() throws JspException {
		super.doStartTag();
		// Skip the body by default. Data is not always available in all iteration states and could cause errors during body evaluation. 
		int ret=SKIP_BODY;
		if(beanTable !=null) {
			BeanTableTag.RowStatus rst=beanTable.getRowStatus();
			if(BeanTableTag.RowStatus.TAGS==rst){
				BeanTableRowAction beanTableRowAction=new BeanTableRowAction(bundle,name,href,hrefURL,classSimpleNameHrefMap);
				beanTable.addRowAction(beanTableRowAction);
				ret=SKIP_BODY;
			}else if(BeanTableTag.RowStatus.DATA==rst && BeanTableTag.ColStatus.ACTION==beanTable.getColStatus()){
				// Update possible row changes
				BeanTableRowAction btra=rowAction();
				btra.setHref(href);
				btra.setHrefURL(hrefURL);
				btra.setClassSimpleNameHrefMap(classSimpleNameHrefMap);
				// Data should be valid in this state. Buffer body evaluation to print it out later by bean table tag
				ret=EVAL_BODY_BUFFERED;
				//System.out.println(objIdentStr()+": doStartTag "+name+ " EVAL_BODY_BUFFERED");
			}
		}
		
		return ret;
	}

	public int doAfterBody() throws JspException {
		String bodyContentStr=null;
		BodyContent bodyContent=getBodyContent();
		if(bodyContent!=null) {
			bodyContentStr=bodyContent.getString();
			BeanTableRowAction btra=rowAction();
			btra.setBodyContentStr(bodyContentStr);
		}
		return SKIP_BODY;
	}
	
	public int doEndTag() throws JspException {
		super.doEndTag();
		return EVAL_PAGE;
	}

	public String getBundle() {
		return bundle;
	}

	public void setBundle(String bundle) {
		this.bundle = bundle;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getHref() {
		return href;
	}

	public void setHref(String action) {
		this.href = action;
	}
	
	public Map<String, String> getClassSimpleNameHrefMap() {
		return classSimpleNameHrefMap;
	}

	public void setClassSimpleNameHrefMap(Map<String, String> classHrefMap) {
		this.classSimpleNameHrefMap = classHrefMap;
	}

	
}
