package ipsk.jsp.taglib.beans.table;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.beans.PropertyNameOrder;
import ipsk.io.StreamCopy;
import ipsk.jsp.BeanTableController;
import ipsk.jsp.BeanTableModel;
import ipsk.jsp.Controller;
import ipsk.jsp.taglib.ControllerProvider;
import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.beans.BeanControllerProvider;
import ipsk.jsp.taglib.beans.BeanProperty;
import ipsk.jsp.taglib.beans.BeanPropertySecureTokenTag;
import ipsk.net.EditableURI;
import ipsk.net.Utils;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.persistence.PersistenceUtils;
import ipsk.text.html.HTMLTextEncoder;
import ipsk.util.ResourceKey;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.ControllerException;
import ipsk.webapps.SelectMode;
import ipsk.webapps.SelectMode.ActionType;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.persistence.CascadeType;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.Tag;

public class BeanTableTag extends ExtBodyTagSupport implements
		BeanControllerProvider {

	public static enum RowStatus {
		TAGS, CUSTOMIZER, HEADER, DATA
	};

	public static enum ColStatus {
		SELECT, DATA, ACTION
	};
	
	// enum handling
	
	public final static String KEY_ENUM_VALUE="_enum_value";

	private String actionOnSelected = null;

	private String additionalCols = null;
	
	private String defColOrder = null;

	private String[] defOrder = null;
	
	private String beanVar;

	private List<BeanTableRowAction> rowActions = new ArrayList<BeanTableRowAction>();

	public List<BeanTableRowAction> getRowActions() {
		return rowActions;
	}

	// private ArrayList<PropertyDescriptor> displayedProps;
	private Hashtable<String, BeanTableCol> colTags = new Hashtable<String, BeanTableCol>();

	protected PropertyDescriptor idPropertyDescriptor = null;
	protected boolean isEnum=false;

	private String tableClass = null;

	private BeanTableController controller;

	private BeanTableModel beanTableModel;

	private List<String> displayColumnNames;

	private int currentRow = -1;

	private int currentColPropertyIndex = -1;

	protected String currentProperty = null;

	protected boolean currentPropertyDone = false;

	// protected boolean scanningTags=false;

	private String resourceBundleName = null;

	// private boolean headerDone=false;
	private boolean selectionColumnDone = false;

	private List items = null;

	private Object item = null;
	private Object idVal=null;

	private RowStatus rowStatus;

	private ColStatus colStatus = ColStatus.SELECT;
	
	public ColStatus getColStatus() {
		return colStatus;
	}

	private boolean bodyProcessed=false;
	private Vector<Object> selectedIdsToDisplay=null;
	
	private boolean rowSelected=false;
	private String tdEmphasizeBegin="";
	private String tdEmphasizeEnd="";
	
	private String trEmphasizeClass=null;
	private String trEmphasizeClassAttribute="";

	private String[] additionalColsArr=null;

	public String[] getAdditionalColsArr() {
		return additionalColsArr;
	}

	private ExtBeanInfo beanInfo;
	private BeanDescriptor beanDescriptor;
	private Class<?> beanClass;
	
	
	public String getColHeader(String colName){
		ExtBeanInfo beanInfo = beanTableModel.getExtBeanInfo();
		String resBundleName = beanInfo.getResourceBundleName();
		BeanTableCol btc = colTags.get(colName);
		String header = btc.getName();

		String bundle = btc.getBundle();
		String headerKey = btc.getKey();


		if (bundle != null && headerKey != null) {
			header = LocaleSupport.getLocalizedMessage(pageContext,
					headerKey, bundle);
		} else if(headerKey!=null){
			header = LocaleSupport.getLocalizedMessage(pageContext,
					headerKey);
		}else if(btc instanceof BeanPropertyTableCol){
			BeanPropertyTableCol bptc=(BeanPropertyTableCol)btc;
			BeanProperty bp=bptc.getBeanProperty();
			PropertyDescriptor pd = bp.getPropertyDescriptor();
			if (pd != null) {

				String rk = (String) pd.getValue(ResourceKey.class
						.getName());
				if (resBundleName != null && rk != null) {
					header = LocaleSupport.getLocalizedMessage(pageContext,
							rk, resBundleName);
				} else {
					header = pd.getShortDescription();
				}
			}
		}
		return header;
	}
	
	
	private void printHeader(JspWriter ow) throws IOException {
		
		SelectMode selectMode=beanTableModel.getSelectMode();
		// print table header

		
		ow.print("<tr>");
		if (selectMode!=null) {
			ow.print("<th>" + getLocalizedMessage("select") + "</th>");
		}
		for (String p : displayColumnNames) {
			String header=getColHeader(p);
			ow.print("<th>" + HTMLTextEncoder.encode(header) + "</th>");
		}

		if (selectMode==null && rowActions.size() > 0) {
			ow.print("<th>" + getLocalizedMessage("action") + "</th>");
		}

		ow.println("</tr>");

	}

	public void setParent(Tag parent){
		colTags.clear();
		super.setParent(parent);
		if (parent instanceof ControllerProvider) {
			Controller scontroller = ((ControllerProvider) parent).getController();
			if(scontroller instanceof BeanTableController){
				controller=(BeanTableController)scontroller;
			}
			try {
				beanTableModel = controller.getBeanTableModel(((HttpServletRequest)pageContext.getRequest()));
			} catch (ControllerException e) {
				e.printStackTrace();
				// TODO should got to doSatrtTag th throw the exception
				
				
			}
		}
		beanInfo = beanTableModel.getExtBeanInfo();
		beanDescriptor=beanInfo.getBeanDescriptor();
		beanClass=beanDescriptor.getBeanClass();
		
		PropertyDescriptor[] pds = beanInfo.getPersistencePropertyDescriptors();
		

		for (PropertyDescriptor pd : pds) {
			Method rm = pd.getReadMethod();
			if (rm.getAnnotation(javax.persistence.Id.class) != null
					|| rm.getAnnotation(javax.persistence.EmbeddedId.class) != null) {
				idPropertyDescriptor = pd;
			}
			String pName = pd.getName();
				if (!colTags.containsKey(pName)) {
					// add default col
					BeanPropertyTableCol btct = new BeanPropertyTableCol(pd,beanInfo);
					//btct.setGenerated(true);
					//btct.setPageContext(pageContext);
					//btct.setParent(this);
					colTags.put(pName, btct);
				}
		}
		
		if(idPropertyDescriptor==null && beanClass.isEnum()){
			isEnum=true;
		}
		
	}

	public int doStartTag() throws JspException {
		// super.doStartTag();
		bodyProcessed=false;
		items=null;
		rowActions.clear();
		//ExtBeanInfo beanInfo = beanTableModel.getExtBeanInfo();
		PropertyDescriptor[] pds = beanInfo.getPersistencePropertyDescriptors();

		// for (PropertyDescriptor pd : pds) {
		// Method rm = pd.getReadMethod();
		// if (rm.getAnnotation(javax.persistence.Id.class) != null
		// || rm.getAnnotation(javax.persistence.EmbeddedId.class) != null) {
		// idPropertyDescriptor = pd;
		// }
		// String pName = pd.getName();
		//
		// if (!pName.equals("class")) {
		// if (colTags.containsKey(pName)) {
		// BeanTableColTag b = colTags.get(pName);
		// } else {
		// // add default col tag
		// BeanTableColTag btct=new BeanTableColTag(pd);
		// btct.setPageContext(pageContext);
		// btct.setParent(this);
		// colTags.put(pName, btct);
		// }
		// }
		//
		// }
		
		if(additionalColsArr!=null){
			controller.setAdditionalColumns(additionalColsArr);
		}
		displayColumnNames = controller.getDisplayColumns();
		if (displayColumnNames == null) {
			
			// No custom col order
//			PropertyOrder propertyOrder = new PropertyOrder(colTags.keySet());
//			propertyOrder.addOrder(beanInfo.getPreferredDisplayOrder());
//			propertyOrder.addOrder(defOrder);
			PropertyNameOrder propertyOrder=new PropertyNameOrder(colTags.keySet());
			propertyOrder.applyPreferredOrder(beanInfo.getPreferredDisplayOrder());
			propertyOrder.applyPreferredOrder(defOrder);
			String[] displayedPropertiesStr = propertyOrder.getOrder();
			displayColumnNames = new ArrayList<String>();
			for (String s : displayedPropertiesStr) {
				boolean added=false;
				if(additionalColsArr!=null){
					for (String addCol : additionalColsArr) {
						if (s.equals(addCol)) {
							displayColumnNames.add(s);
							added=true;
							break;
						}
					}
				}
				if(added) continue;
				for (PropertyDescriptor pd : pds) {
					if (s.equals(pd.getName())) {
						displayColumnNames.add(s);
						break;
					}
				}


			}
			
			// Security
			displayColumnNames.removeAll(beanInfo.getHiddenProperties());
			
			controller.setDisplayColumns(displayColumnNames);
		}

		// first run: scan tags inside bean table tag
		rowStatus = RowStatus.TAGS;
		
		if(beanTableModel.getSelectMode()!=null){
			Object[] allSelIds=beanTableModel.getSelectedIds();
			if(allSelIds!=null){
				selectedIdsToDisplay = new Vector<Object>();
				selectedIdsToDisplay.addAll(Arrays.asList(allSelIds));
			}else{
				selectedIdsToDisplay = null;
			}
		}
		
		return EVAL_BODY_INCLUDE;
	}
	

	private void printTableStartTags() throws IOException {
		JspWriter ow = pageContext.getOut();

		String cssClassAttr = "";
		if (tableClass != null)
			cssClassAttr = " class=\"" + tableClass + "\"";
		SelectMode selectMode=beanTableModel.getSelectMode();
		if (selectMode != null) {
			
			String actionOnSel=selectMode.getAction();
			if(actionOnSelected!=null) {
				actionOnSel=actionOnSelected;
			}
			
			if(selectMode.isMultiSelection()){
				// requires Javascript ips_lib.js
				String saopStr=LocaleSupport.getLocalizedMessage(pageContext,"select.all.on_page","ipsk.jsp.Messages");
				ow.println("<form><input type=\"checkbox\" name=\"_select_all\" value=\"select-all\" onchange=\"ips_selectAllToggle(this,'beanTableForm');\">"+saopStr+"</input></form>");
			}
			ow.println("<form id= \"beanTableForm\" method=\"post\" action=\""
							+ encodeURL(actionOnSel)
							+ "\" accept-charset=\"UTF-8\" enctype=\"application/x-www-form-urlencoded;charset=utf-8\">");

		}
		ow.println("<table" + cssClassAttr + ">");

	}

	public int doAfterBody() throws JspException {
		JspWriter ow = pageContext.getOut();
		
		//ExtBeanInfo beanInfo = beanTableModel.getExtBeanInfo();
		SelectMode selectMode=beanTableModel.getSelectMode();
		if (rowStatus == RowStatus.TAGS) {
			rowStatus = RowStatus.CUSTOMIZER;
			idVal=null;
		} else if (rowStatus == RowStatus.CUSTOMIZER) {
			try {
				printTableStartTags();
			} catch (IOException e) {
				throw new JspException(
						"Error: IOException while writing table customizers");
			}
			rowStatus = RowStatus.HEADER;
		} else if (rowStatus == RowStatus.HEADER) {
			try {
				printHeader(ow);
			} catch (IOException e) {
				throw new JspException();
			} finally {
				rowStatus = RowStatus.DATA;
				
				colStatus = ColStatus.SELECT;
			}

		}  else if (rowStatus == RowStatus.DATA) {

			if (colStatus == ColStatus.SELECT) {

				if (items == null) {
					// table content
					items = beanTableModel.getItems();
					currentRow = -1;
				}
				currentRow++;
				if (currentRow >= items.size()) {
					// Finished: print end tag
					bodyProcessed=true;
					return SKIP_BODY;
				}
				if (currentRow < items.size()) {

					item = items.get(currentRow);
					if(beanVar!=null){
						pageContext.setAttribute(beanVar, item,
								PageContext.REQUEST_SCOPE);
					}
					if (idPropertyDescriptor != null) {
						Method idRm = idPropertyDescriptor.getReadMethod();
						try {
							idVal = idRm.invoke(item, new Object[0]);
						} catch (Exception e) {
							throw new JspException(
									"Could not read id (primary key): ", e);
						}
						// check if row is selected (emphasized)
						Object[] selRowsIds=beanTableModel.getSelectedRowsIds();
						rowSelected=false;
						tdEmphasizeBegin="";
						tdEmphasizeEnd="";
						trEmphasizeClassAttribute="";
						if(selRowsIds!=null){
						for(Object selRowsId:selRowsIds){
							if(selRowsId.equals(idVal)){
								rowSelected=true;
								if(trEmphasizeClass!=null){
									trEmphasizeClassAttribute=" class=\""+trEmphasizeClass+"\" ";
								}else{
									tdEmphasizeBegin="<em>";
									tdEmphasizeEnd="</em>";
								}
								
							}
						}
						}
					}else if(isEnum){
						idVal=item;
					}
				}
				try {
					ow.print("<tr"+trEmphasizeClassAttribute+">");

					if (selectMode != null) {
						String selStr = "";
						//Object[] selectedIds = beanTableModel.getSelectedIds();
						
						if (selectedIdsToDisplay != null) {
							for (Object sId : selectedIdsToDisplay) {
								if (sId.equals(idVal)) {
									selStr = " checked";
									selectedIdsToDisplay.remove(sId);
									break;
								}
							}
						}
						String type = "radio";
						
						ow.print("<td>");
						
						String selectName=null;
						String selectValue=null;
						if(idPropertyDescriptor!=null){
							selectName=idPropertyDescriptor.getName();
							selectValue=idVal.toString();
						}else if(beanClass.isEnum()){
							selectName=KEY_ENUM_VALUE;
							// use name here as key, toString or value does not work to retrieve the enum later by valueOf(String) method
							selectValue=((Enum<?>)idVal).name();
						}
						
						if (selectMode.isMultiSelection()){
							type = "checkbox";
							
							// TODO does not work. Wrong results. It might be only necessary for a change of an multi selection
							// add and remove should work without it 
							
//							// the controller needs to know the selected _AND_ the unselected item IDs
//							// to change the multiple selection properly
//							// we send the controller a hidden input for each item (row) 
//							ow.print("<input type=\"hidden\" name=\""
//									+ selectMode.getTargetProperty()
//									+ "." + selectName
//									+ "\" value=\"" + HTMLTextEncoder.encode(selectValue) + "\"" + selStr
//									+ ">");
						}

						String selectDisabledStr="";
						if(!controller.itemSelectable(item)) {
							selectDisabledStr=" disabled=\"disabled\"";
						}
						ow.print("<input type=\"" + type + "\""+selectDisabledStr+" name=\""
								+ selectMode.getTargetProperty()
								+ "." + selectName
								+ "\" value=\"" + HTMLTextEncoder.encode(selectValue) + "\"" + selStr
								+ "></td>");
					}

					// table data columns ...

				} catch (IOException ioe) {
					throw new JspException(
							"Error: IOException while writing row data ");
				}
				colStatus = ColStatus.DATA;
				currentProperty=null;
				currentColPropertyIndex = -1;
			} else if (colStatus == ColStatus.DATA) {
				// set current column property
				currentColPropertyIndex++;
				if (currentColPropertyIndex < displayColumnNames.size()) {
					currentProperty = displayColumnNames.get(currentColPropertyIndex);
					BeanTableCol btc = colTags.get(currentProperty);
					if (btc instanceof BeanPropertyTableCol) {
						BeanPropertyTableCol bptc=(BeanPropertyTableCol)btc;
						if(bptc.getVar()==null){
							bptc.printTag(pageContext,item,bptc.getValueCssClass(),bptc.getMaxTextLength());
						}
					}
				} else {
					currentProperty=null;
					colStatus = ColStatus.ACTION;
				}

			} else if (colStatus == ColStatus.ACTION) {
				// ... and table action columns
				try {
					if (selectMode==null) {
						
						boolean modifyable=true;
						boolean removable=true;
						try {
							modifyable = controller.modifyable(item);
							removable = controller.removable(item);
						} catch (ControllerException e1) {
							throw new JspException(e1);
						}

						String actionsStr = "";
						for (BeanTableRowAction action : rowActions) {
							
							//if(action.getName()==null) continue;
							// enable updates/removes
							boolean actionEnabled=true;
							
							if(action.isRemoving()){
								actionEnabled=removable;
							}else if(action.isModifying()){
								actionEnabled=modifyable;
							}
									
							String href = null;
							if(actionEnabled){
								String hrefUrl=action.getHrefURL();
								
								if(hrefUrl!=null){
									href=hrefUrl; 
								}else{
									String baseHref = action.getHref();
									if(baseHref==null && item!=null) {
										Map<String,String> classHrefMap=action.getClassSimpleNameHrefMap();
										if(classHrefMap!=null) {
											String itemClassSimpleName=item.getClass().getSimpleName();
											baseHref=classHrefMap.get(itemClassSimpleName);
										}
									}
									if (baseHref != null){
										EditableURI eUri=new EditableURI(encodeURL(baseHref)); 
										if (idVal != null && idPropertyDescriptor != null) {

											if (beanInfo.isIdEmbedded()) {
												PropertyDescriptor[] embPds = beanInfo
														.getEmbeddedIdBeanInfo()
														.getPropertyDescriptors();
												//boolean first = true;
												for (PropertyDescriptor embPd : embPds) {
													if (!embPd.getName().equals("class")) {
														Method rm = embPd.getReadMethod();
														Object embVal;
														try {
															embVal = rm.invoke(idVal,
																	new Object[0]);
														} catch (Exception e) {
															e.printStackTrace();
															throw new JspException(
																	"Reflection error");
														}
														//											if (!first)
														//												idQuery = idQuery.concat("&");
														eUri.appendQuery(idPropertyDescriptor
																.getName()
																+ "."
																+ embPd.getName(),embVal);
														//first = false;
													}
												}
											} else {
												eUri.appendQuery(idPropertyDescriptor.getName(),idVal);
											}
										}
										String cmd = action.getControllerCommand();
										eUri.appendQuery(BasicPersistenceBeanController.KEY_CMD,cmd);
										href=eUri.getHTMLEncodedUri();
									}
								}
							}
							
							String actionStr = "";
							if (actionEnabled && href != null) {
								// begin anchor tag
								actionStr = actionStr.concat("<a href=\"" + href + "\">");
							}
							String actionBodyStr=action.getBodyContentStr();
							if(actionBodyStr!=null) {
								// if the btrowaction tag has a body append it
								actionStr=actionStr.concat(actionBodyStr);
							}else {
								// else try to get resource bundle/key and wrap the localized message in square brackets to indicate an action link  
								String actionResourceBundle=action.getResourceBundle();
								String actionResourceKey=action.getResourceKey();
								if(actionResourceBundle!=null && actionResourceKey!=null) {
									String actionName=LocaleSupport.getLocalizedMessage(
											pageContext, actionResourceKey,
											actionResourceBundle);
									
									boolean noBrRequired=(actionName.indexOf(' ')>=0);
									String aNmStr=actionName;
									if(!action.isImmediately()) {
										// indicate to user that command is not deleting/removing immediately
										// e.g. it will look like this: [Delete...]
										aNmStr=aNmStr.concat("...");
									}
									String encActionStr=HTMLTextEncoder.encode(aNmStr);
									if(noBrRequired) {
										// enclose in nowrap span if action contains at least one blank  
										encActionStr="<span style=\"white-space:nowrap\">"+encActionStr+"</span>";
									}
									actionStr = actionStr.concat("["+ encActionStr+ "]");
								}
							}
							
							if (actionEnabled && href != null) {
								// close anchor tag
								actionStr = actionStr.concat("</a>");
							}
							// concat to all actions string
							actionsStr = actionsStr.concat(actionStr);

						}
						if (!actionsStr.equals("")) {
							// print action table cell for current row
							ow.print("<td>" + actionsStr + "</td>");
						}
						
					}

					ow.println("</tr>");

				} catch (IOException ioe) {
					throw new JspException(
							"Error: IOException while writing actions");
				} finally {
					currentProperty=null;
					colStatus = ColStatus.SELECT;
				}

			}
		}

		return EVAL_BODY_AGAIN;
	}

	public int doEndTag() throws JspException {
		
		if (!bodyProcessed){
			while(doAfterBody()==EVAL_BODY_AGAIN);
			bodyProcessed=true;
		}
		SelectMode selectMode=beanTableModel.getSelectMode();
		JspWriter ow = pageContext.getOut();
		try {
			ow.println("</table>");
			if (selectMode!=null) {
				
				SelectMode.ActionType selActionType=null;
				selActionType=selectMode.getActionType();
				
				//String selectCommand = beanTableModel.getSelectCommand();
				
				ServletRequest sReq=pageContext.getRequest();
				if(sReq instanceof HttpServletRequest) {
					HttpServletRequest req=(HttpServletRequest)sReq;
					String sie=BeanPropertySecureTokenTag.secureRequestTokenInputElement(req);
					ow.println(sie);
				}

				if(selActionType==ActionType.ADD || selActionType==ActionType.REMOVE || selActionType==ActionType.DELETE || selActionType == ActionType.SET || selActionType == ActionType.RESET){
					
					// Add information about related  object to modify
					PersistenceObjectIdentifier poi=controller.getRelatedObjectIdentifier();
					ExtBeanInfo beanInfo=PersistenceIntrospector.getPersistenceBeanInfo(poi.getTargetClass(),true);
					ow.print("<input type=\"hidden\" name=\""
							+ beanInfo.getIdPropertyDescriptor().getName()
							+ "\" value=\"" + HTMLTextEncoder.encode(poi.getIdObject().toString()) + "\">");
					
					
//					ow.print("<input type=\"hidden\" name=\""
//							+ PersistenceObjectIdentifier.KEY_TARGET_CLASS
//							+ "\" value=\"" + poi.getTargetClass().getName() + "\">");
//					ow.print("<input type=\"hidden\" name=\""
//							+ PersistenceObjectIdentifier.KEY_ID
//							+ "\" value=\"" + controller.getRelatedObjectIdentifier().getIdObject() + "\">");
					
				}
				if (selActionType==ActionType.SET) {
					
					// print hidden (because of paging), but selected objects
					
					// NO ! do not print hidden ID's
					// if the currently selected ID is not on the page and the user selects
					// one , there will be returned two items !
//					if (selectedIdsToDisplay != null) {
//						for (Object invisibleSelObj : selectedIdsToDisplay) {
//							ow.print("<input type=\"hidden\" name=\""
//									+ selectMode.getTargetProperty()
//									+ "." + idPropertyDescriptor.getName()
//									+ "\" value=\"" + invisibleSelObj + "\">");
//						}
//					}
					
					ow.print("<input type=\"submit\" name=\"_"
							+ BasicPersistenceBeanController.CMD_STORE_SET_RELATED + "\" value=\""
							+ getLocalizedMessage("select") + "\"/>");
					ow.print("<input type=\"submit\" name=\"_"
							+ BasicPersistenceBeanController.CMD_CANCEL_STORE_RELATED + "\" value=\""
							+ getLocalizedMessage("cancel") + "\"/>");
				} else if (selActionType==ActionType.RESET) {
					
					// print hidden (because of paging), but selected objects
//					if (selectedIdsToDisplay != null) {
//						for (Object invisibleSelObj : selectedIdsToDisplay) {
//							ow.print("<input type=\"hidden\" name=\""
//									+ selectMode.getTargetProperty()
//									+ "." + idPropertyDescriptor.getName()
//									+ "\" value=\"" + invisibleSelObj + "\">");
//						}
//					}
					
					ow.print("<input type=\"submit\" name=\"_"
							+ BasicPersistenceBeanController.CMD_STORE_RESET_RELATED + "\" value=\""
							+ getLocalizedMessage("remove") + "\"/>");
					ow.print("<input type=\"submit\" name=\"_"
							+ BasicPersistenceBeanController.CMD_CANCEL_STORE_RELATED + "\" value=\""
							+ getLocalizedMessage("cancel") + "\"/>");
				}else if (selActionType==ActionType.ADD) {
					
					ow.print("<input type=\"submit\" name=\"_"
							+ BasicPersistenceBeanController.CMD_STORE_ADD_RELATED
							+ "\" value=\"" + getLocalizedMessage("add")
							+ "\"/>");
					ow.print("<input type=\"submit\" name=\"_"
							+ BasicPersistenceBeanController.CMD_CANCEL_STORE_RELATED + "\" value=\""
							+ getLocalizedMessage("cancel") + "\"/>");
				} else if (selActionType==ActionType.REMOVE) {
					ow.print("<input type=\"submit\" name=\"_"
							+ BasicPersistenceBeanController.CMD_STORE_REMOVE_RELATED
							+ "\" value=\"" + getLocalizedMessage("remove")
							+ "\"/>");
					ow.print("<input type=\"submit\" name=\"_"
							+ BasicPersistenceBeanController.CMD_CANCEL_STORE_RELATED + "\" value=\""
							+ getLocalizedMessage("cancel") + "\"/>");
				}else if (selActionType==ActionType.DELETE) {
					
					ow.print("<input class=\"warn\" type=\"submit\" name=\"_"
							+ BasicPersistenceBeanController.CMD_STORE_DELETE_RELATED
							+ "\" value=\"" + getLocalizedMessage("delete")
							+ "\"/>");
					ow.print("<input type=\"submit\" name=\"_"
							+ BasicPersistenceBeanController.CMD_CANCEL_STORE_RELATED + "\" value=\""
							+ getLocalizedMessage("cancel") + "\"/>");
				}else if (selActionType==ActionType.CHANGE_SELECTION) {
					
					ow.print("<input type=\"submit\" name=\"_"
							+ BasicPersistenceBeanController.CMD_LIST_CHANGE_SELECTION
							+ "\" value=\"" + getLocalizedMessage("selection.change")
							+ "\"/>");
					ow.print("<input type=\"submit\" name=\"_"
							+ BasicPersistenceBeanController.CMD_CANCEL + "\" value=\""
							+ getLocalizedMessage("cancel") + "\"/>");
				}
				
				ow.println("<input type=\"reset\" name=\"_"
						+ BasicPersistenceBeanController.CMD_CANCEL + "\" value=\""
						+ getLocalizedMessage("reset") + "\"/>");
				
				ow.println("</form>");
			}
		} catch (IOException e) {
			e.printStackTrace();
			throw new JspException(e.getMessage());
		} catch (IntrospectionException e) {
			e.printStackTrace();
			throw new JspException(e.getMessage());
		}
		return EVAL_PAGE;
	}

	public String getTableClass() {
		return tableClass;
	}

	public void setTableClass(String sclass) {
		tableClass = sclass;
	}

//	public void addColumn(BeanTableColTag col) {
//		BeanProperty bp=col.getBeanProperty();
//		bp=new BeanProperty()
//		String key =bp.getName();
//
//		colTags.put(key, col);
//	}

	public String getDefColOrder() {
		return defColOrder;
	}

	public void setDefColOrder(String colOrder) {
		this.defColOrder = colOrder;
		StringTokenizer colOrderTokenizer = new StringTokenizer(defColOrder,
				",");
		int dispPropsCount = colOrderTokenizer.countTokens();
		defOrder = new String[dispPropsCount];
		for (int i = 0; i < dispPropsCount; i++) {
			defOrder[i] = colOrderTokenizer.nextToken().trim();
		}
	}

	public void addRowAction(BeanTableRowAction action) {
		rowActions.add(action);

	}

	public List<String> getDisplayColumns() {
		return displayColumnNames;
	}

	public BeanTableController getController() {

		return controller;
	}

	public ExtBeanInfo getBeanInfo() {
		return beanTableModel.getExtBeanInfo();
	}

	public String getCurrentProperty() {
		return currentProperty;
	}

	public void setCurrentProperty(String currentProperty) {
		this.currentProperty = currentProperty;
	}

	public RowStatus getRowStatus() {
		return rowStatus;
	}

	public void setRowStatus(RowStatus rowStatus) {
		this.rowStatus = rowStatus;
	}

	public Object getItem() {
		return item;
	}

	public BeanTableModel getBeanTableModel() {
		return beanTableModel;
	}
	
	public String getActionOnSelected() {
		return actionOnSelected;
	}

	public void setActionOnSelected(String action) {
		this.actionOnSelected = action;
	}

	public String getTrEmphasizeClass() {
		return trEmphasizeClass;
	}

	public void setTrEmphasizeClass(String tdEmphasizeClass) {
		this.trEmphasizeClass = tdEmphasizeClass;
	}

	public BeanTableCol getColumn(String name){
		return colTags.get(name);
	}
	
	public BeanProperty getBeanProperty(String name) {
		BeanTableCol btc=colTags.get(name);
		if(btc instanceof BeanPropertyTableCol){
			return ((BeanPropertyTableCol)btc).getBeanProperty(); 
		}
		return null;
	}

	public String getAdditionalCols() {
		return additionalCols;
	}

	public void setAdditionalCols(String additionalCols) {
		this.additionalCols = additionalCols;
		StringTokenizer addColsTokenizer = new StringTokenizer(additionalCols,
				",");
		int c = addColsTokenizer.countTokens();
		additionalColsArr = new String[c];
		for (int i = 0; i < c; i++) {
			additionalColsArr[i] = addColsTokenizer.nextToken().trim();
		}
		if(additionalColsArr!=null){
			for(String addColName:additionalColsArr){
				BeanTableCol btct = new BeanTableCol(addColName);
				
				colTags.put(addColName, btct);
			}
		}
	}

	public String getBeanVar() {
		return beanVar;
	}

	public void setBeanVar(String beanVar) {
		this.beanVar = beanVar;
	}

}
