package ipsk.jsp.taglib.beans.view;

import ipsk.jsp.taglib.beans.BeanPropertySecureTokenTag;
import ipsk.jsp.taglib.beans.BeanProviderTag;
import ipsk.jsp.taglib.beans.table.BeanTableCol;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.SecureRequestTokenProvider;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.StringTokenizer;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class BeanViewTag extends BeanProviderTag {

	
	private String tableClass;
	private String tableClassAttr="";
	
	private String actionCommand=BasicPersistenceBeanController.CMD_VIEW;
	private String action=null;
	
	protected Boolean defaultHideIfEmpty=null;
	public Boolean getDefaultHideIfEmpty() {
		return defaultHideIfEmpty;
	}

	public void setDefaultHideIfEmpty(Boolean defaultHideIfEmpty) {
		this.defaultHideIfEmpty = defaultHideIfEmpty;
	}
	
	private boolean hasBody=false;
	
	private boolean displayActionForm(){
		return (actionCommand!=null && (actionCommand.equals(BasicPersistenceBeanController.CMD_REMOVE) || actionCommand.equals(BasicPersistenceBeanController.CMD_DELETE) || actionCommand.equals(BasicPersistenceBeanController.CMD_EXPORT)));
	}
	
	private boolean deletingAction() {
		return (BasicPersistenceBeanController.CMD_DELETE.equals(actionCommand));
	}
	
	public int doStartTag() throws JspException {
		super.doStartTag();
		
		JspWriter w = pageContext.getOut();
		
		try {
			if(displayActionForm()){
				String hrefAction=null;
				if(action!=null){
					hrefAction=action;
				}else{
				HttpServletRequest req=(HttpServletRequest)pageContext.getRequest();
				hrefAction=req.getRequestURL().toString();
				}
				w.println("<form action=\""+encodeURL(hrefAction)+"\">");
				ServletRequest sReq=pageContext.getRequest();
				if(sReq instanceof HttpServletRequest) {
					HttpServletRequest req=(HttpServletRequest)sReq;
					String sie=BeanPropertySecureTokenTag.secureRequestTokenInputElement(req);
					w.println(sie);
				}
			}
			w.println("<table"+tableClassAttr+">");
		} catch (IOException e) {
			throw new JspException(e);
		}
		hasBody=false;
		return EVAL_BODY_INCLUDE;
	}

	protected void processProperty() throws JspException{
		Iteration it=getIteration();
		
		if (currentProperty !=null && !currentPropertyDone){
			if(Iteration.TABLE.equals(it)){
		
			BeanPropertyTag bpt=new BeanPropertyTag();
			bpt.setPageContext(pageContext);
			bpt.setParent(this);
			try {
				bpt.getBeanProperty().setContext(this);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				throw new JspException("cold not set bean provider context.",e);
			} 
			bpt.printTag();
			}
			setCurrentPropertyDone(true);
		}
	}
	
	public int doAfterBody() throws JspException {
		//JspWriter w=pageContext.getOut();
		hasBody=true;
		processProperty();
		return super.doAfterBody();
	}

	public int doEndTag() throws JspException {
		JspWriter w = pageContext.getOut();
		if(!hasBody){
			// doAferBody was not called
			// so we have to print the tags
			do{
				processProperty();
			}while(nextProperty());
		}
		try {
			w.println("</table>");
			if(displayActionForm()){
				PropertyDescriptor idPd=beanInfo.getIdPropertyDescriptor();
				Object idValue;
				try {
					idValue = beanInfo.getIdValue(getBeanModel().getBean());
				} catch (Exception e) {
					
					e.printStackTrace();
					throw new JspException("Could not get ID value");
				}
				String actionMessage="";
				if(BasicPersistenceBeanController.CMD_DELETE.equals(actionCommand)){
					//actionMessage="<span class=\"warn\">"+getLocalizedMessage("delete")+"</span>";
					actionMessage=getLocalizedMessage("delete");
				}else if (actionCommand.equals(BasicPersistenceBeanController.CMD_REMOVE)){
					actionMessage=getLocalizedMessage("delete");
				}else if(actionCommand.equals(BasicPersistenceBeanController.CMD_EXPORT)){
					actionMessage=getLocalizedMessage("export");
				}
				String cancelMessage=getLocalizedMessage("cancel");
				
				w.println("<input type=\"hidden\" name=\""+idPd.getName()+"\" value=\""+idValue+"\"/>");
				
				String cssWarnClassStr="";
				if(deletingAction()) {
					cssWarnClassStr=" class=\"warn\"";
				}
				w.println("<input"+cssWarnClassStr+" type=\"submit\" name=\"_"+actionCommand+"\" value=\""+actionMessage+"\"/>");
				
				// export calls a servlet which has no cancel division
				if(!actionCommand.equals(BasicPersistenceBeanController.CMD_EXPORT)){
					w.println("<input type=\"submit\" name=\"_"+BasicPersistenceBeanController.CMD_CANCEL+"\" value=\""+cancelMessage+"\"/>");
				}
				w.println("</form>");
			}
		} catch (IOException e) {
			throw new JspException(e);
		}
		return EVAL_PAGE;
	}

	
	public String getTableClass() {
		return tableClass;
	}

	public void setTableClass(String tableClass) {
		this.tableClass = tableClass;
		tableClassAttr=" class=\""+tableClass+"\"";
	}

	public String getActionCommand() {
		return actionCommand;
	}

	public void setActionCommand(String actionCommand) {
		this.actionCommand = actionCommand;
	}

	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}


	

}
