/*
 * Created on Mar 9, 2006
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package ipsk.net;


import ipsk.jsp.fmt.LocaleSupport;
import ipsk.math.bool.BoolExpr;
import ipsk.math.bool.ExtBoolExpr;
import ipsk.persistence.text.StringObjectConverter;
import ipsk.text.ParserException;
import ipsk.webapps.BasicPersistenceBeanController;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

import javax.persistence.criteria.Expression;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class BoolExprQueryParser {
	
	public static final String IS_KEY="is_key";
	public static final String NE_KEY="ne_key";
	
	public static final String IS= "is";
	public static final String NE= "ne";
	
	public static final String CONTAINS="contains";
	public static final String STARTS="starts";
	public static final String ENDS= "ends";
	public static final String GT= "gt";
	
	public static final String LT= "lt";
	public static final String GE ="ge";
	public static final String LE="le";
	
	public static final String EQUALS= "equals";
	public static final String MEMBER="member";
	public static final String EQUALS_NOT= "equals_not";
	public static final String NOT_MEMBER= "not_member";
	
	public static final String BOUND= "bound";
	public static final String NOT_BOUND="not_bound";
	
	public static final String CASE_INSENSITIVE_VAL="insensitive";

    protected Hashtable<String,String> ht=null;
    protected ServletRequest req=null;
    protected Class<?> beanClass=null;
    protected PropertyDescriptor[] beanProperties=null;
	private Locale locale=null;
    
    public BoolExprQueryParser(ServletRequest req){
        this.req=req;
    }
    
    public BoolExprQueryParser(ServletRequest req,Class beanClass) throws ParserException{
    	this(req,beanClass,null);
    	String localeStr=req.getParameter(BasicPersistenceBeanController.KEY_LOCALE);
		if (localeStr!=null){
			locale=LocaleSupport.parse(localeStr);
		}
		if(locale==null){
			//locale=(Locale)(Config.find(pageContext,javax.servlet.jsp.jstl.core.Config.FMT_LOCALE));
			locale=LocaleSupport.getLocale(req);
		}
    	if(locale ==null && req instanceof HttpServletRequest){
    			locale=((HttpServletRequest)req).getLocale();
    	}
    }
    
    public BoolExprQueryParser(ServletRequest req,Class beanClass,Locale locale) throws ParserException{
        this.req=req;
        this.beanClass=beanClass;
        this.locale=locale;
        BeanInfo beanInfo;
		try {
			beanInfo = Introspector.getBeanInfo(beanClass);
		} catch (IntrospectionException e1) {
			throw new ParserException(e1);
		}
		
		beanProperties = beanInfo.getPropertyDescriptors();
		
		
    }
    
    public BoolExprQueryParser(Hashtable<String,String> ht){
        this.ht=ht;
    }
//    public BoolExprQueryParser(String queryString){
//        ht=HttpUtils.parseQueryString(queryString);
//    }
    
    
    public  ExtBoolExpr parse() throws ParserException {
        
    ExtBoolExpr retVal=null;
       retVal=parseCondition(0);
       if (retVal==null){
    	   String op0=getParameter("_ec0");
    	   if (op0==null || op0.equals("")) return null;
    	   String o0=getParameter("_eo0");
    	   if (o0==null || o0.equals("")) return null;
           retVal=parseExpression(0);
           
       }
       return retVal;
    }

    
    private String getParameter(String paramName){
        if(req!=null) {
            return req.getParameter(paramName);
        }else if(ht!=null) {
            Object o=ht.get(paramName);
            if(o==null)return null;
            return ((String[])(o))[0];
        }
        return null;
    }
    
    private ExtBoolExpr parseCondition(int index) throws ParserException{
        String c=getParameter("_c"+index);
        if (c==null) return null;
        ExtBoolExpr retVal=new ExtBoolExpr();
        StringTokenizer st=new StringTokenizer(c,"_");
        String co1=st.nextToken();
        int ind=Integer.parseInt(co1.substring(1));  
        if (co1.startsWith("e")){ 
        retVal.setOperand0(parseExpression(ind));
        }else if(co1.startsWith("c")){
            retVal.setOperand0( parseCondition(ind));
        }else{
            throw new ParserException();
        }
        if (!st.hasMoreTokens()){
            return retVal;
        }else{
            String coo=st.nextToken();
            //retVal.setOperator(coo);
            String co2=st.nextToken();
            int ind2=Integer.parseInt(co2.substring(1));  
            if (co2.startsWith("e")){ 
            retVal.setOperand1(parseExpression(ind2));
            }else if(co2.startsWith("c")){
                retVal.setOperand1(parseCondition(ind2));
            }else{
                throw new ParserException();
            }
            if (retVal != null) {
                retVal.setOperator(coo);
                // Eliminate null operands (with empty column or operand operand)
                if(retVal.getOperand0()==null){
                    retVal=(ExtBoolExpr)retVal.getOperand1();
                }else if(retVal.getOperand1()==null){
                    retVal=(ExtBoolExpr)retVal.getOperand0();
                }
            }
        }
        return retVal;
    }
    private ExtBoolExpr parseExpression(int ind) throws ParserException {
      
    	 String op0=getParameter("_ec"+ind);
    	 String opr=getParameter("_eo"+ind);
    	if (op0 == null || opr==null || op0.equals("") || opr.equals(""))
            return null;
        ExtBoolExpr retVal=new ExtBoolExpr();

        String op1=getParameter("_ev"+ind);
        if(op0==null || opr==null || op1==null) throw new ParserException();
        Object boolOp=getBoolExprOperator(opr);
        Class<?> propertyType=null;
        Object op1Val=op1;
        String caseInsensitiveParam=getParameter("_eci"+ind);
        boolean caseInSensitive=(caseInsensitiveParam!=null && caseInsensitiveParam.equals(CASE_INSENSITIVE_VAL));
        if (beanClass!=null && beanProperties!=null){
        	// determine column type
        	for(PropertyDescriptor pd:beanProperties){
        		if (pd.getName().equals(op0)){
        			propertyType=pd.getPropertyType();
        			if(!ExtBoolExpr.isOperatorSupportingType(boolOp, propertyType)){
        				throw new ParserException("Operator does not support "+propertyType.getName());
        			}

        			try {
        				if(propertyType.isEnum()) {
        					if(ExtBoolExpr.isKeyOperator(boolOp)) {
        						op1Val=StringObjectConverter.stringToObject(op1, pd,locale,true,false);
        					}else {
        						op1Val=StringObjectConverter.stringToObject(op1, pd,locale,false,true);
        					}
        				}else {
        					op1Val=StringObjectConverter.stringToObject(op1, pd,locale);
        				}
        			} catch (ParserException e) {
        				throw new ParserException(e);
        			}
        		}
        	}
        }
        if(propertyType !=null && propertyType.equals(String.class)){
        	retVal.setCaseInSensitive(caseInSensitive);
        }
        retVal.setOperand0(op0);
        retVal.setOperator(boolOp);
        retVal.setOperand1(op1Val);
        return retVal;
    }
    
    
    
    public static String getQueryOperator(Object extBoolOperator) {
//    	 use a Hashtable for this !!!
        if (extBoolOperator == null)
            return "";
        if (extBoolOperator.equals(ExtBoolExpr.EQUAL_KEY))
            return IS_KEY;
        if (extBoolOperator.equals(ExtBoolExpr.NOT_EQUAL_KEY))
            return NE_KEY;
        if (extBoolOperator.equals(ExtBoolExpr.EQUAL))
            return IS;
        if (extBoolOperator.equals(ExtBoolExpr.NOT_EQUAL))
            return NE;
        if (extBoolOperator.equals(ExtBoolExpr.CONTAINS))
            return CONTAINS;
        if (extBoolOperator.equals(ExtBoolExpr.STARTS_WITH))
            return STARTS;
        if (extBoolOperator.equals(ExtBoolExpr.ENDS_WITH))
            return ENDS;
        if (extBoolOperator.equals(ExtBoolExpr.GREATER_THEN))
            return GT;
        if (extBoolOperator.equals(ExtBoolExpr.LESS_THEN))
            return LT;
        if (extBoolOperator.equals(ExtBoolExpr.GREATER_EQUAL))
            return GE;
        if (extBoolOperator.equals(ExtBoolExpr.LESS_EQUAL))
            return LE;
        if (extBoolOperator.equals(ExtBoolExpr.EQUALS))
            return EQUALS;
        if (extBoolOperator.equals(ExtBoolExpr.MEMBER))
            return MEMBER;
        if (extBoolOperator.equals(ExtBoolExpr.EQUALS_NOT))
            return EQUALS_NOT;
        if (extBoolOperator.equals(ExtBoolExpr.NOT_MEMBER))
            return NOT_MEMBER;
        if (extBoolOperator.equals(ExtBoolExpr.BOUND))
            return BOUND;
        if (extBoolOperator.equals(ExtBoolExpr.NOT_BOUND))
            return NOT_BOUND;
        return null;
    }
    
    public static String getBoolExprOperator(String queryOperator) {
    	// use a Hashtable for this !!!
    	if (queryOperator == null)
            return ExtBoolExpr.EQUAL;
        if (queryOperator.equals(IS_KEY))
            return ExtBoolExpr.EQUAL_KEY;
        if (queryOperator.equals(NE_KEY))
            return ExtBoolExpr.NOT_EQUAL_KEY;
        if (queryOperator.equals(IS))
            return ExtBoolExpr.EQUAL;
        if (queryOperator.equals(NE))
            return ExtBoolExpr.NOT_EQUAL;
        if (queryOperator.equals(CONTAINS))
            return ExtBoolExpr.CONTAINS;
        if (queryOperator.equals(STARTS))
            return ExtBoolExpr.STARTS_WITH;
        if (queryOperator.equals(ENDS))
            return ExtBoolExpr.ENDS_WITH;
        if (queryOperator.equals(GT))
            return ExtBoolExpr.GREATER_THEN;
        if (queryOperator.equals(LT))
            return ExtBoolExpr.LESS_THEN;
        if (queryOperator.equals(GE))
            return ExtBoolExpr.GREATER_EQUAL;
        if (queryOperator.equals(LE))
            return ExtBoolExpr.LESS_EQUAL;
        if (queryOperator.equals(EQUALS))
            return ExtBoolExpr.EQUALS;
        if (queryOperator.equals(MEMBER))
            return ExtBoolExpr.MEMBER;
        if (queryOperator.equals(EQUALS_NOT))
            return ExtBoolExpr.EQUALS_NOT;
        if (queryOperator.equals(NOT_MEMBER))
            return ExtBoolExpr.NOT_MEMBER;
        if (queryOperator.equals(BOUND))
            return ExtBoolExpr.BOUND;
        if (queryOperator.equals(NOT_BOUND))
            return ExtBoolExpr.NOT_BOUND;
        
        return null;
    }
    
    
//    public static void main(String[] args){
//        BoolExprQueryParser q=new BoolExprQueryParser("_c0=e0_and_c1&_ec0=col0&_eo0=is&_ev0=val0&_ec1=col1&_eo1=ends&_ev1=val1&_c1=e1_or_e2&_ec2=col2&_eo2=is&_ev2=val2");
//    	//BoolExprQueryParser q=new BoolExprQueryParser("_cmd=list");
//        ExtBoolExpr be=null;
//        try {
//            be = q.parse();
//            PersistenceBoolExprConverter pbec=new PersistenceBoolExprConverter(be);
//            PersistenceBoolExpr pqd=pbec.createQueryData();
//            System.out.println("PQL: "+pqd.getConditionalExpression());
//            Object[] vars=pqd.getQueryVars();
//            for(Object var:vars){
//            System.out.println("Var: "+(String)var);
//            }
//        } catch (ParserException e) {
//            // TODO Auto-generated catch block
//            e.printStackTrace();
//        }
//        
//    }
    
    
}
