package ipsk.webapps;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ips.beans.PersistenceMapConverter;
import ipsk.beans.BeanModel;
import ipsk.beans.MapConverter;
import ipsk.beans.MapConverterException;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.form.FormConfiguration;
import ipsk.beans.form.PropertyConfiguration;
import ipsk.beans.validation.BeanValidator;
import ipsk.beans.validation.ValidationException;
import ipsk.beans.validation.ValidationResult;
import ipsk.jsp.BeanTableModel;
import ipsk.jsp.Controller;
import ipsk.math.bool.ExtBoolExpr;

import ipsk.persistence.ParameterizedQuery;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.persistence.SecurityManager;
import ipsk.sql.OrderByClause;
import ipsk.util.LocalizableMessage;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;



// TODO not in use
public abstract class BasicBeanController<T> implements BeanValidator,Controller {

	

	
	// key for command
	public final static String KEY_CMD = "_cmd";
	
	


	public class EntityManagerThreadLocal extends ThreadLocal<EntityManager> {

		//private EntityManagerFactory emf;

//		public EntityManagerThreadLocal(EntityManagerFactory emf) {
//			this.emf = emf;
//		}
		

		protected synchronized EntityManager initialValue() {
			//return emf.createEntityManager();
			return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
		}

	}

	//private EntityManagerFactory emf;

	private EntityManagerThreadLocal emtl;

	// protected EntityManager em;
	protected Class<T> queryType;

	protected String queryTypeName;

	protected String jsfIdentifier;



	protected int firstItem = 0;

	private String namedQuery = null;
	private ParameterizedQuery parameterizedQuery = null;

	//private RelatedQuery relatedQuery=null;
	private ExtBoolExpr boolCondition;

	private OrderByClause orderByClause;

	//private Object namedQueryParam;

	private Object[] namedQueryParams = null;

	//private String namedQueryParamClassName;

	private PersistenceObjectIdentifier namedQueryParam;
	
	private String[] additionalColumns;
	public String[] getAdditionalColumns() {
		return additionalColumns;
	}

	public void setAdditionalColumns(String[] additionalColumns) {
		this.additionalColumns = additionalColumns;
	}

	private String[] displayColumns;

	private ExtBeanInfo beanInfo = null;

	// private PropertyDescriptor idPropertyDescriptor = null;

	private Object id;

	//private Object item = null;

	private boolean idGenerated = false;

	protected BeanTableModel<T> beanTableModel;
	
	
	private boolean actionCanceled;

	private Object selectedItemId;
	private Set<Object> selectedItemIds;
	
	protected HttpServletRequest currentRequest;
	public void setCurrentRequest(HttpServletRequest currentRequest) {
		this.currentRequest = currentRequest;
	}
	protected SecurityManager securityManager=new SecurityManager();
	protected ServletContext servletContext;

	public ServletContext getServletContext() {
		return servletContext;
	}

	public void setServletContext(ServletContext servletContext) {
		this.servletContext = servletContext;
	}

	
	protected BeanModel<T> beanModel=null;
	protected ProcessResult processResult;
	
	private boolean checkSecureRequestToken=false;
	
	public void setCheckSecureRequestToken(boolean checkSecureRequestToken) {
		this.checkSecureRequestToken = checkSecureRequestToken;
	}
	
	public FormConfiguration getFormConfiguration() {
		return null;
	}

	public static String RESOURCE_BUNDLE_NAME="ipsk.jsp.Messages";
	
	private static LocalizableMessage VALIDATION_MSG_FIELD_REQUIRED=new LocalizableMessage(RESOURCE_BUNDLE_NAME,"validation.field.required");

	// private LocalizableMessage errorMessage = null;
	public BasicBeanController(String persistenceUnit, Class<T> queryType) {
		this(persistenceUnit, queryType, queryType.getName());
	}

	public BasicBeanController(String persistenceUnit, Class<T> queryType,
			String jsfIdentifier) {
		this.queryType = queryType;
		queryTypeName = queryType.getName();
		
		try {
			beanInfo = PersistenceIntrospector.getExtendedBeanInfo(queryType,true,false);
		} catch (IntrospectionException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();

		for (PropertyDescriptor pd : pds) {

			// Class type = pd.getPropertyType();
			Method rm = pd.getReadMethod();
			// if (rm.getAnnotation(javax.persistence.Id.class) != null
			// || rm.getAnnotation(javax.persistence.EmbeddedId.class) != null)
			// {
			// idPropertyDescriptor = pd;
			// }
			if (rm.getAnnotation(javax.persistence.GeneratedValue.class) != null) {
				setIdGenerated(true);
			}
		}
		this.jsfIdentifier = jsfIdentifier;

		// emf = Persistence.createEntityManagerFactory(persistenceUnit);
		//emf = EntityManagerFactoryInitializer.getEntityManagerFactory();
		//emtl = new EntityManagerThreadLocal(emf);
		emtl=new EntityManagerThreadLocal();

	}
	
	
	public void open(){
		EntityManager em= getThreadEntityManager();
		EntityTransaction tx=em.getTransaction();
		if(tx!=null && ! tx.isActive()){
		tx.begin();
		}
	}

	public ExtBeanInfo getBeanInfo() {
		try {
			return PersistenceIntrospector.getPersistenceBeanInfo(queryType);
		} catch (IntrospectionException e1) {
			return null;
		}
	}

	public EntityManager getEntityManager() {
		//return emf.createEntityManager();
		return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
	}

	public EntityManager getThreadEntityManager() {
		if (emtl == null) {
			//emtl = new EntityManagerThreadLocal(emf);
			emtl=new EntityManagerThreadLocal();
		}
		return emtl.get();
	}

	public PropertyDescriptor[] getBeanProperties() {
		BeanInfo beanInfo;
		try {
			beanInfo = Introspector.getBeanInfo(queryType);
		} catch (IntrospectionException e1) {
			return null;
		}
		PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();

		return pds;
	}
	



	
	public T getById(Object id) {
		EntityManager em = getThreadEntityManager();
		T o = em.find(queryType, id);
		return o;
	}

	public void selectItem(HttpServletRequest request) throws ControllerException{	
		Map<String,String[]> pMap=request.getParameterMap();
		setSelectedItemId(request, createIdObject(pMap));
	}

	protected void setPropertiesAfterSelect(HttpServletRequest request, Object selObject) {
		// Does nothing
		// To be overridden by controller subclasses
	}
	
	protected void setPropertiesAfterSelect(HttpServletRequest request, Set<Object> selObjects) {
		// Does nothing
		// To be overridden by controller subclasses
	}

	
	public void createBeanModel(HttpServletRequest request) throws ControllerException{
		Map<String,String[]> map = request.getParameterMap();
		Object idObj = createIdObject(map);
		EntityManager em = getThreadEntityManager();
		
		T editItem;
		try {
			
			editItem = em.find(queryType, idObj);
			if(editItem==null){
				throw new NoSuchObjectException(idObj);
			}
			PersistenceMapConverter mapConverter = new PersistenceMapConverter();
			try {
				mapConverter.setBeanProperties(editItem, map, em, false,request,securityManager);
				securityManager.checkReadPermission(request, editItem);
				beanModel=new BeanModel<T>(editItem);
			} catch (MapConverterException e) {
				e.printStackTrace();
				throw new ControllerException(
						"Could not apply property values.", e);
			}
		} catch (PersistenceException e) {
			e.printStackTrace();
			close();
			throw e;
		}
	}
	
	@SuppressWarnings("unchecked")
	private void createSingleItemModel(HttpServletRequest req) throws ControllerException {
		if (namedQuery == null && id == null) {
			throw new ControllerException(
					"No named query or ID to load single object!");
		}
		T singleItem=null;
		EntityManager em = getThreadEntityManager();
	
		if (namedQuery != null) {
			Query q = null;
			Object idObj = null;
			q = em.createNamedQuery(namedQuery);
			if (namedQueryParam != null) {
				try {

					idObj = em.find(namedQueryParam.getTargetClass(),
							namedQueryParam.getIdObject());
				} catch (Exception e) {
					e.printStackTrace();
					throw new ControllerException(e);
				}

				q.setParameter(1, idObj);

			} else {
				if (namedQueryParams != null) {
					for (int pi = 0; pi < namedQueryParams.length; pi++) {
						q.setParameter(pi + 1, namedQueryParams[pi]);
					}
				}
			}
			try {
				singleItem = (T) q.getSingleResult();
			} catch (NoResultException nre) {
				beanModel=null;
			}
		} else if (id != null) {
			singleItem = em.find(queryType, id);
		}
		
		
		// if permission check OK set the item
		if(singleItem!=null){
			securityManager.checkReadPermission(req, singleItem);
			em.refresh(singleItem);
			beanModel =new BeanModel<T>(singleItem);
		}
	}
	
	

	
	public T getItem() throws ControllerException {

		if (beanModel == null) createSingleItemModel(currentRequest);
		if(beanModel!=null){
			return beanModel.getBean();
		}else{
			return null;
		}

	}

	
	
	public String[] getDisplayColumns() {
		return displayColumns;
	}

	protected void setPropertiesOnNew(Object bean) {
		// Does nothing
		// To be overwritten by special controllers
	}

	protected void setPropertiesOnCreate(HttpServletRequest request,EntityManager em,Object bean) {
		// Does nothing
		// To be overwritten by special controllers
	}
	
	protected void setPropertiesAfterQuery(HttpServletRequest request,EntityManager em,Object o) {
		// Does nothing
		// To be overwritten by special controllers
	}
	
//	protected void setPropertiesBeforeStore(HttpServletRequest request,EntityManager em,Object bean) {
//		// Does nothing
//		// To be overwritten by special controllers
//	}

	public ValidationResult validate(Object o,ValidationResult validationResult) throws ValidationException{
		FormConfiguration formConfiguration=getFormConfiguration();
		ValidationResult vr=validationResult;
		boolean defaultRequired=false;
		if(vr==null){
		vr=new ValidationResult();
		}
		if (queryType.isAssignableFrom(o.getClass())){
			
			
//			if(formConfiguration!=null){
//				boolean formRequired=formConfiguration.isDefaultRequired();
//				boolean formShow=formConfiguration.isDefaultShow();
//				defaultRequired=formRequired&&formShow;
//			}
			PropertyDescriptor[] pPds=beanInfo.getPersistencePropertyDescriptors();
			for (PropertyDescriptor pd:pPds){
				String pdName=pd.getName();
				PropertyValidationResult prVr=vr.getPropertyValidationResult(pdName);
				// Ignore already existing errors
				if(prVr==null || prVr.isValid()){
					boolean required=defaultRequired;
					if(formConfiguration!=null){
						List<PropertyConfiguration> propCfgs=formConfiguration.getPropertyConfigurations();
						for(PropertyConfiguration pCfg:propCfgs){
							if(pd.equals(pCfg.getPropertyDescriptor())){
								required=pCfg.isRequired()&&pCfg.isShow();
								break;
							}
						}
					}
					Method rm=pd.getReadMethod();
					Object val;
					try {
						val = rm.invoke(o, new Object[]{});
					} catch (Exception e) {
						e.printStackTrace();
						throw new ValidationException(e);
					}
					Column colAnno=pd.getReadMethod().getAnnotation(Column.class);

					if(colAnno!=null){
						// check nullable
						if(! colAnno.nullable() && val==null){
							vr.setType(ValidationResult.Type.ERRORS);
							LocalizableMessage msg=new LocalizableMessage(beanInfo.getResourceBundleName(),"validation.field.must_be_set");
							vr.putPropertyValidationResult(pd.getName(), new PropertyValidationResult(PropertyValidationResult.Type.ERROR,msg));
						}

						if(required){
							if(val==null || pd.getPropertyType().equals(String.class) && "".equals(val)){
								vr.setType(ValidationResult.Type.ERRORS);
								vr.putPropertyValidationResult(pd.getName(),new PropertyValidationResult(PropertyValidationResult.Type.ERROR,VALIDATION_MSG_FIELD_REQUIRED));

							}

						}
						// check length of string
						if(pd.getPropertyType().equals(String.class)){
							if(val!=null && ((String)val).length() > colAnno.length()){
								vr.setType(ValidationResult.Type.ERRORS);
								LocalizableMessage msg=new LocalizableMessage(beanInfo.getResourceBundleName(),"validation.field.too_long");
								vr.putPropertyValidationResult(pd.getName(),new PropertyValidationResult(PropertyValidationResult.Type.ERROR,msg));
							}
						}
					}
				}
			}
		}else{
			throw new ValidationException("Object has not type of controller !");
		}
		
		return vr;
	}
	
	
	protected void apply(HttpServletRequest request, String command)
			throws ControllerException {
		Map<String,String[]> map = request.getParameterMap();
		BeanModel<T> newBeanModel=null;
		T newItem= null;
		try {
			newItem = queryType.newInstance();
		} catch (InstantiationException e1) {

			e1.printStackTrace();
			throw new ControllerException(e1);
		} catch (IllegalAccessException e1) {
			e1.printStackTrace();
			throw new ControllerException(e1);
		}
		
		EntityManager em = getThreadEntityManager();
		//securityManager.checkPersistPermission(request, newItem);
//		boolean idGenerated=beanInfo.isIdGenerated();
		// pre persist the item
//		if(idGenerated){
//			em.persist(newItem);
//		}
			setPropertiesOnCreate(request,em,newItem);
			PersistenceMapConverter mapConverter = new PersistenceMapConverter();
			try {
				//mapConverter.setBeanProperties(newItem, map, em, true,request,securityManager);
				newBeanModel=(BeanModel<T>) mapConverter.createBeanModel(newItem, map, em, false, request, securityManager);
			} catch (MapConverterException e) {
				e.printStackTrace();
				//if(idGenerated)em.remove(newItem);
				rollback();
				Throwable cause=e.getCause();
				if(cause instanceof ControllerException){
					throw (ControllerException)cause;
				}
				throw new ControllerException("Could not apply properties.", e);
			}
			ExtBeanInfo bInfo = getBeanInfo();
			if (bInfo.getIdPropertyDescriptor() != null && !isIdGenerated()) {
				// check if id already exists
				Object idO;
				try {
					idO = bInfo.getIdValue(newItem);
				} catch (Exception e) {
					
					e.printStackTrace();
					em.remove(newItem);
					throw new ControllerException(e);
				}
				Object exO = em.find(bInfo.getBeanDescriptor().getBeanClass(),
						idO);
				if (exO != null) {
					throw new ObjectAlreadyExistsException(idO);
				}
			}
		
			ValidationResult validationResult=null;
			try {
				validationResult=validate(newBeanModel.getBean(),newBeanModel.getValidationResult());
			} catch (ValidationException e) {
				e.printStackTrace();
				throw new ControllerException(e);
			}
			processResult=new ProcessResult(validationResult);
//			if (validationResult.isValid()) {
//			securityManager.checkMergePermission(request, newItem);
//			if(idGenerated){
//				em.merge(newItem);
//			}else{
//				em.persist(newItem);
//			}
//			em.flush();
//		}else{
//			
////			 rollback does not remove the new item !!! TopLink Bug ?
//			//em.remove(newItem);
//			rollback();
//
//			
//		}
			
			beanModel=new BeanModel<T>(newItem,validationResult);
			
		//mode=new ListMode();
		//item=o;
		//createViewModel(request);
		//createBeanTableModel(command,request);
	}
	
//	@SuppressWarnings("unchecked")
//	protected void add(HttpServletRequest request, String command)
//	throws ControllerException {
////		Map map = request.getParameterMap();
//		Map<String,String[]> map = (Map<String,String[]>)request.getParameterMap();
//		T newItem= null;
//		try {
//			newItem = queryType.newInstance();
//		} catch (InstantiationException e1) {
//
//			e1.printStackTrace();
//			throw new ControllerException(e1);
//		} catch (IllegalAccessException e1) {
//			e1.printStackTrace();
//			throw new ControllerException(e1);
//		}
//
//		EntityManager em = getThreadEntityManager();
//		securityManager.checkPersistPermission(request, newItem);
//		BeanModel<T> newBeanModel=new BeanModel<T>(newItem);
//		boolean idGenerated=beanInfo.isIdGenerated();
//		
//		// pre persist the item
//		// if(idGenerated){
//			PersistenceMapConverter<T> mapConverter = new PersistenceMapConverter<T>();
//			
//			try {
//				if(mapConverter.createPrepersistBeanModel(newItem, map,newBeanModel)) {
//					em.persist(newItem);
//					em.flush();
//				}
//				
//			} catch (MapConverterException e) {
//				throw new ControllerException(e);
//			}
//			
//		//}
//		setPropertiesOnCreate(request,em,newItem);
//		BeanModel<T> mergeModel=newBeanModel;
////		mergeProperties(request, newBeanModel);
////	}
////		
////	
////	@SuppressWarnings("unchecked")
////	private void mergeProperties(HttpServletRequest request,BeanModel<T> mergeModel) throws ControllerException{
//			T mergeItem=mergeModel.getBean();
////			Map<String,String[]> map = (Map<String,String[]>)request.getParameterMap();
////			EntityManager em = getThreadEntityManager();
//		//PersistenceMapConverter mapConverter = new PersistenceMapConverter();
//		
//		try {
//			//mapConverter.setBeanProperties(newItem, map, em, true,request,securityManager);
//			mapConverter.applyToBeanModel(mergeModel, map, em, true, request, securityManager);
//		} catch (MapConverterException e) {
//			e.printStackTrace();
//			//if(idGenerated)em.remove(newItem);
//			rollback();
//			Throwable cause=e.getCause();
//			if(cause instanceof ControllerException){
//				throw (ControllerException)cause;
//			}
//			throw new ControllerException("Could not apply properties.", e);
//		}
//		ExtBeanInfo bInfo = getBeanInfo();
//		if (bInfo.getIdPropertyDescriptor() != null && !isIdGenerated()) {
//			// check if id already exists
//			Object idO;
//			try {
//				idO = bInfo.getIdValue(mergeItem);
//			} catch (Exception e) {
//
//				e.printStackTrace();
//				em.remove(mergeItem);
//				throw new ControllerException(e);
//			}
//			Object exO = em.find(bInfo.getBeanDescriptor().getBeanClass(),
//					idO);
//			if (exO != null) {
//				throw new ObjectAlreadyExistsException(idO);
//			}
//		}
//
//		ValidationResult validationResult=null;
//		try {
//			validationResult=validate(mergeModel.getBean(),mergeModel.getValidationResult());
//		} catch (ValidationException e) {
//			e.printStackTrace();
//			throw new ControllerException(e);
//		}
//		processResult=new ProcessResult(validationResult);
//		if (validationResult.isValid()) {
//			securityManager.checkMergePermission(request, mergeItem);
//			if(idGenerated){
//				em.merge(mergeItem);
//			}else{
//				em.persist(mergeItem);
//			}
//			em.flush();
//		}else{
//
//			//	 rollback does not remove the new item !!! TopLink Bug ?
//			//em.remove(newItem);
//			rollback();
//
//
//		}
//
//		beanModel=new BeanModel<T>(mergeItem,validationResult);
//	}
//	
//	
//	
//	
//	
	
	
	public String processCommand(HttpServletRequest request,String[] possibleSubmitCommands){
		String command = request.getParameter(KEY_CMD);
		
		// find submit commands
		for (String possibleSubmitCmd :possibleSubmitCommands) {
			if (request.getParameter("_" + possibleSubmitCmd) != null) {
				command = possibleSubmitCmd;
				break;
			}
		}
		return command;
	}
	
	/**
	 * Compatibility method implementation only.
	 * @throws ControllerException 
	 */
	public ProcessResult process(HttpServletRequest request,HttpServletResponse response,Servlet servlet) throws ControllerException{
		processRequest(request);
		return getProcessResult();
	}
	public abstract void processRequest(HttpServletRequest request);
		

	/**
	 * Compatibility method implementation only.
	 * @throws ControllerException 
	 */
	public ProcessResult process(HttpServletRequest request,HttpServletResponse response) throws ControllerException{
		processRequest(request);
		return getProcessResult();
	}
	
	

	protected Object createIdObject(Map<String,String[]> map) throws ControllerException {
		Object idObj = null;
		if (beanInfo.isIdEmbedded()) {
			PropertyDescriptor idPd = beanInfo.getIdPropertyDescriptor();
			// construct embedded id object

			try {
				idObj = idPd.getPropertyType().newInstance();
			} catch (Exception e) {

				e.printStackTrace();
				throw new ControllerException(e);
			}

			// construct "toplevel" property map

			HashMap<String,String[]> embProps = new HashMap<String, String[]>();
			Set<Map.Entry<String,String[]>> entries2 = map.entrySet();
//			Iterator ei2 = entries2.iterator();
//			while (ei2.hasNext()) {
			for(Map.Entry<String,String[]> entry2:entries2){
//				Map.Entry<String,String[]> entry2 = ei2.next();
				String key2 =entry2.getKey();
				// Object value2 = entry2.getValue();

				int dotIndex2 = key2.indexOf('.');
				String keyName2 = null;
				String deepProperty2 = null;
				if (dotIndex2 > 0) {
					keyName2 = key2.substring(0, dotIndex2);
					deepProperty2 = key2.substring(dotIndex2 + 1);
					if (!keyName2.equals(idPd.getName())) {
						continue;
					}
					embProps.put(deepProperty2, entry2.getValue());
				}
			}

			// apply map
			MapConverter embMc = new MapConverter();
			try {
				embMc.setBeanProperties(idObj, embProps);
			} catch (MapConverterException e) {

				e.printStackTrace();
				throw new ControllerException(e);
			}
		} else {
			String[] idStrs = map.get(beanInfo
					.getIdPropertyDescriptor().getName());
			if (idStrs != null && idStrs.length == 1 && idStrs[0] != null) {
				String idStr = idStrs[0];
				try {
					idObj = beanInfo.createIdValueByString(idStr);
					if (idObj == null)
						throw new ControllerException(
								"Could not get item with id=" + idStr);
					setId(idObj);
				} catch (Exception e) {
					e.printStackTrace();
					throw new ControllerException(e);
				}
			} else {
				// try object identifier
				try {
					PersistenceObjectIdentifier poi = PersistenceObjectIdentifier.parseQueryMap(map);
					if(poi!=null){
						idObj=poi.getIdObject();
					}
				} catch (Exception e) {
					e.printStackTrace();
					throw new ControllerException(e);
				}

			}
		}
		return idObj;
	}
	
	
	public void rollback(){
		EntityManager em = getThreadEntityManager();
		if (em != null) {
			EntityTransaction tx = null;
				tx = em.getTransaction();
				if (tx!=null && tx.isActive()) {
					tx.rollback();
				}
		}
	}
	
	public void commit() throws ControllerException{
		EntityManager em = getThreadEntityManager();
		if (em != null) {
			EntityTransaction tx = null;
			try {
				tx = em.getTransaction();
				if (tx!=null && tx.isActive()) {
					tx.commit();
				}
			} catch (PersistenceException e) {
				e.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();

				setBoolCondition(null);
				throw new ControllerException(e);
			} catch (IllegalStateException ise) {
				ise.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();

				setBoolCondition(null);
				throw new ControllerException(ise);
			} catch (Exception e) {
				e.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();
				throw new ControllerException(e);
			} 
		}
	}
	
	protected void clear(){
		processResult=null;
		beanModel=null;
		beanTableModel=null;
		//validationResult=null;
		actionCanceled=false;
		
	}
	
	public synchronized void close()  {

		EntityManager em = getThreadEntityManager();
		
		// for open JPA it is required to   
		try {
			commit();
		} catch (ControllerException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (em != null) {
			em.close();
		}
		if (emtl != null) {
			emtl.remove();
			// emtl=null;
		}
	}

	public ExtBoolExpr getBoolCondition() {
		return boolCondition;
	}

	public void setBoolCondition(ExtBoolExpr boolCondition) {
		ExtBoolExpr oldCondition = this.boolCondition;
		this.boolCondition = boolCondition;
		if (this.boolCondition == null) {
			if (oldCondition != null)
				firstItem = 0;
		} else {
			//namedQuery = null;
			if (!this.boolCondition.equals(oldCondition))
				firstItem = 0;
		}
	}

	public OrderByClause getOrderByClause() {
		return orderByClause;
	}

	public void setOrderByClause(OrderByClause orderByClause) {
		this.orderByClause = orderByClause;
	}

	public String getNamedQuery() {
		return namedQuery;
	}

	public void setNamedQuery(String namedQuery,PersistenceObjectIdentifier namedQueryParam) {
		this.namedQuery = namedQuery;
		//this.namedQueryParamClassName = namedQueryParamClassName;
		this.namedQueryParam = namedQueryParam;
		namedQueryParams = null;
		if (namedQuery != null) {
			parameterizedQuery=null;
			boolCondition = null;
			orderByClause = null;
			
		}
		firstItem = 0;
	}

	public void setDisplayColumns(String[] displayColumns) {
		this.displayColumns = displayColumns;
	}

	public boolean isIdGenerated() {
		return idGenerated;
	}

	public void setIdGenerated(boolean idGenerated) {
		this.idGenerated = idGenerated;
	}

	public Object getId() {
		return id;
	}

	public void setId(Object id) {
		this.id = id;
	}

	// reqired getters for JSTL access
	// Eclipse suggest static modifiers, but this does not work !
//	public String getKEY_SELECT_TARGET_CLASS() {
//		return KEY_SELECT_TARGET_CLASS;
//	}

	

	public Object getSelectedItemId() {
		return selectedItemId;
	}
	
	public Object getSelectedItem() {
		if(selectedItemId==null)return null;
		EntityManager em=getThreadEntityManager();
		Object ret=em.find(queryType, selectedItemId);
		return ret;
	}

	public void setSelectedItemId(HttpServletRequest request,Object selectedItemId) {
		this.selectedItemId = selectedItemId;
		setPropertiesAfterSelect(request, selectedItemId);
	}

	public void setSelectedItemIds(HttpServletRequest request,Set<Object> selectedItemIds) {
		this.selectedItemIds = selectedItemIds;
		setPropertiesAfterSelect(request, selectedItemIds);
	}

	public Set<Object> getSelectedItemIds() {
		return selectedItemIds;
	}

	public boolean isActionCanceled() {
		return actionCanceled;
	}

	public ParameterizedQuery getParameterizedQuery() {
		return parameterizedQuery;
	}

	public void setParameterizedQuery(ParameterizedQuery parameterizedQuery) {
		this.parameterizedQuery = parameterizedQuery;
		namedQuery=null;
	}

//	public ValidationResult getValidationResult() {
//		return validationResult;
//	}

	public BeanModel getBeanModel() {
		return beanModel;
	}

	public ProcessResult getProcessResult() {
		return processResult;
	}

	

	public SecurityManager getSecurityManager() {
		return securityManager;
	}

	public void setSecurityManager(SecurityManager securityManager) {
		this.securityManager = securityManager;
	}

	

}
