package ipsk.webapps;

import java.util.Map;
import java.util.Map.Entry;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * Controls the lifecycle of an JPA entity manager factory.
 * The factory is created when the web application context is initialized and closed when the context is destroyed.
 * @author klausj
 *
 */
public class EntityManagerFactoryInitializer implements ServletContextListener {

	private static boolean DEBUG = true;

	private static EntityManagerFactory entityManagerFactory;
	

	public static void closeEntityManagerFactory(ServletContext context){
		if (DEBUG)
			System.out
					.println("Entity manager factory listener: Context destroyed. ("
							+ entityManagerFactory + ").");
		if (entityManagerFactory != null) {

			entityManagerFactory.close();
			context.log("Closed entity manager factory.("
					+ entityManagerFactory + ").");
			context.removeAttribute("entityManagerFactory");
			entityManagerFactory = null;
		}
	}
	
	public void contextDestroyed(ServletContextEvent event) {
		ServletContext context = event.getServletContext();
		closeEntityManagerFactory(context);
	}

	public synchronized static void createEntitymanagerFactory(ServletContext context){
		try {
			String persistenceUnitName = context
					.getInitParameter("persistenceUnitName");
			if (entityManagerFactory != null) {
				context.log("Entity manager already exists on initialize !");
				System.err.println("Entity manager factory already exists ! ("
						+ entityManagerFactory + ").");
			} else {
				entityManagerFactory = Persistence
						.createEntityManagerFactory(persistenceUnitName);
				
				context.setAttribute("entityManagerFactory",
						entityManagerFactory);
				context.log("Created entity manager factory \""
						+ persistenceUnitName + "\" (" + entityManagerFactory
						+ ").");
//				Map<String,Object> props=entityManagerFactory.getProperties();
//				for(Entry<String,Object> e:props.entrySet()){
//					context.log("EMF Prop: "+e.getKey()+" : "+e.getValue());
//				}
			}
		} catch (Exception ex) {
			context.log("Couldn't create entity manager factory !", ex);

		}
	}
	
	public void contextInitialized(ServletContextEvent event) {
		ServletContext context = event.getServletContext();
		createEntitymanagerFactory(context);
	}

	public static EntityManagerFactory getEntityManagerFactory() {
		return entityManagerFactory;
	}
	
	public synchronized static void reloadEntityManagerFactory(ServletContext context){
			closeEntityManagerFactory(context);
			createEntitymanagerFactory(context);
	}

}
