package ipsk.webapps;

import ipsk.beans.validation.ValidationResult;
import ipsk.util.LocalizableMessage;

/**
 * Objects of this class represent the result of a controller request.
 * For instance if a page requests to create a new item, the controller creates a new object,
 * validates the input properties to apply. The type of the result can be success, if the validation and storage is successfully, it can be cancelled, if the user has pressed the cancel button or error if the input properties do not satisfy validation or the item cannot be stored.
 * This class is not used to process exceptional states (e.g. caused by bugs) 
 * @author klausj
 *
 */
public class ProcessResult {
	/**
	 * General result type constants.
	 *
	 */
	public enum Type {DONE,SUCCESS,WARNING,ERROR,CANCELLED}
	
	/**
	 * Result type.
	 */
	protected Type type;
	protected String resultKey="";
	public String getResultKey() {
		return resultKey;
	}

	public void setResultKey(String resultKey) {
		this.resultKey = resultKey;
	}

	private LocalizableMessage localizableMessage=null;
	public LocalizableMessage getLocalizableMessage() {
		return localizableMessage;
	}

	public void setLocalizableMessage(LocalizableMessage localizableMessage) {
		this.localizableMessage = localizableMessage;
	}

	private ValidationResult validationResult=null;
	
	/**
	 * Create new process result.
	 * @param type
	 */
	public ProcessResult(Type type){
		super();
		this.type=type;
	}
	
	/**
	 * Creates a process result corresponding to the given bean validation result 
	 * @param validationResult
	 */
	public ProcessResult(ValidationResult validationResult) {
		super();
		this.validationResult=validationResult;
		ValidationResult.Type vrTpye=validationResult.getType();
		if(vrTpye.equals(ValidationResult.Type.SUCCESS)){
			type=Type.SUCCESS;
		}else if(vrTpye.equals(ValidationResult.Type.WARNINGS)){
			type=Type.WARNING;
		}else if(vrTpye.equals(ValidationResult.Type.ERRORS)){
			type=Type.ERROR;
		}else if(vrTpye.equals(ValidationResult.Type.CANCELLED)){
			type=Type.CANCELLED;
		}
	}
	

	
	/**
	 * Get bean validation result.
	 * Intended for add/edit requests, which have to be validated first.
 	 * @return validation result or null if not applicable
	 */
	public ValidationResult getValidationResult() {
		return validationResult;
	}
	/**
	 * Set bean validation result.
	 * Intended for add/edit requests, which have to be validated first.
	 * @param validationResult
	 */
	public void setValidationResult(ValidationResult validationResult) {
		this.validationResult = validationResult;
	}

	/**
	 * Get general result type.
	 * @return
	 */
	public Type getType() {
		return type;
	}
	
	/**
	 * Set general result type.
	 * @return
	 */
	public void setType(Type type) {
		this.type = type;
	}
}
