package ipsk.webapps;

import java.util.Locale;
import java.util.ResourceBundle;

import javax.servlet.http.HttpSession;

/**
 * Convenience class to get a resource bundle.
 * Objects of RsourceBundle are not serializable, so we cannot handle it as an session attribute.
 * @author klausj
 *
 */
public class ResourceBundleManager {
	public static ResourceBundle getResourceBundle(HttpSession session,String name){
		Locale locale=(Locale)session.getAttribute("locale");
		if(locale==null || ! (locale instanceof Locale)){
			return ResourceBundle.getBundle(name);
		}else{
			return ResourceBundle.getBundle(name,locale);
		}
	}
}
