package ipsk.webapps.filter;

import ipsk.text.StringTokenizer;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;

import javax.activation.FileTypeMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MaintenanceSwitch implements Filter {
	public static String MAINTENANCE_WELCOME_FILE_PARAM_NAME="maintenanceWelcomeFile";
	public static String WELCOME_FILES_PARAM_NAME="regularWelcomeFiles";
	public static String MAINTENANCE_CONTENT_FILES_PARAM_NAME="maintenanceContentFiles";
	public static String MAINTENANCE_ATTR_KEY=MaintenanceSwitch.class.getName();
	
	private FilterConfig filterConfig;
	private Date maintenanceEnd;
	String maintenanceIndexFile;
	private String[] welcomeFiles;
	private String[] maintenanceContentFileLists;
	private String maintenanceWelcomeFile;
	
	
	private void sendServiceUnavailable(HttpServletResponse httpRes) throws IOException{
		 if(maintenanceEnd!=null){
			  long maintenanceTime=maintenanceEnd.getTime();
			  maintenanceTime+=1000*60*10;
			  httpRes.addDateHeader("Retry-After", maintenanceTime);
		  }
		  httpRes.sendError(HttpServletResponse.SC_SERVICE_UNAVAILABLE, "Sorry we are in maintenance mode");
	}
	private void sendMaintenaceRedirect(HttpServletRequest httpReq,HttpServletResponse httpRes) throws IOException, ServletException{
		 // redirect to maintenance welcome
//		  httpRes.setStatus(HttpServletResponse.SC_MULTIPLE_CHOICES);
//	  
		  String contextpath=httpReq.getContextPath();
//		  httpRes.sendRedirect(httpRes.encodeRedirectURL(contextpath+maintenanceWelcomeFile));
		  RequestDispatcher rDis=httpReq.getRequestDispatcher(maintenanceWelcomeFile);
		  rDis.forward(httpReq, httpRes);
		  
		  
	}
	
	  public void doFilter(ServletRequest request,
	      ServletResponse response, FilterChain filterChain)
	      throws IOException, ServletException {
		  
		  Object maintAttr=filterConfig.getServletContext().getAttribute(MAINTENANCE_ATTR_KEY);
		  
		  if(maintAttr!=null){
			  if(request instanceof HttpServletRequest && response instanceof HttpServletResponse){
				  HttpServletRequest httpReq=(HttpServletRequest)request;
				  HttpServletResponse httpRes=(HttpServletResponse)response;
				  String servletPath=httpReq.getServletPath();
				  if(maintenanceContentFileLists!=null){
					  for(String contentFile:maintenanceContentFileLists){
						  if(servletPath.equals(contentFile)){
							  filterChain.doFilter(request, response);
							  return;
						  }
					  }
				  }
				  if(maintenanceWelcomeFile!=null && maintenanceWelcomeFile.equals(servletPath)){
					  filterChain.doFilter(request, response);
					  return;
				  }
				  if(welcomeFiles!=null){
					  for(String welcomeFile:welcomeFiles){
						  if(welcomeFile.equals(servletPath) && maintenanceWelcomeFile!=null){
							 sendMaintenaceRedirect(httpReq, httpRes);
							 return;
						  }
					  }
				  }
				  if(servletPath.equals("/") || servletPath.equals("")){
					  sendMaintenaceRedirect(httpReq, httpRes);
					  return;
				  }
				  sendServiceUnavailable(httpRes);
				  return;
			  }
		  }else{
			  filterChain.doFilter(request, response);
		  }
	  }

	  public void init(FilterConfig filterConfig)
		           throws ServletException {
		  this.filterConfig=filterConfig;
//	    String encodingParam = filterConfig
//	              .getInitParameter("");
//	   
		  
//		  filterConfig.getServletContext().setAttribute(MAINTENANCE_ATTR_KEY, new Boolean(true));
		  String welcomeFilesParam=filterConfig.getInitParameter(WELCOME_FILES_PARAM_NAME);
		  welcomeFiles = StringTokenizer.split(welcomeFilesParam, ',',true);
		  
		  String maintenanceContentFilesParam=filterConfig.getInitParameter(MAINTENANCE_CONTENT_FILES_PARAM_NAME);
		  maintenanceContentFileLists = StringTokenizer.split(maintenanceContentFilesParam, ',',true);
		  
		  String maintenaceWelcomeFileParam=filterConfig.getInitParameter(MAINTENANCE_WELCOME_FILE_PARAM_NAME);
		  if(maintenaceWelcomeFileParam!=null){
			  maintenanceWelcomeFile=maintenaceWelcomeFileParam.trim();
		  }
		  
		  
	  }

	
	  
	  public void destroy() {
	    // nothing todo
	  }

}
