//    IPS Java Utils
//    (c) Copyright 2009-2010
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Utils
//
//
//    IPS Java Utils is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Utils is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Utils.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.SingularAttribute;

import ipsk.math.bool.BoolExpr;
import ipsk.math.bool.ExtBoolExpr;

/**
 * Creates conditional expression from boolean expression.
 * 
 * @author klausj
 * 
 */

public class PersistenceCriteriaBoolExprConverter<T> {
	
	//public final static String JPQL_PARAM_NAME_PREFIX="persistenceboolexprconverter";
	
	private CriteriaBuilder cb;
	private BoolExpr boolExpr;
	private Path<T> path;

	public PersistenceCriteriaBoolExprConverter(CriteriaBuilder cb,Path<T> path,BoolExpr boolExpr) {
		this.cb=cb;
		this.path=path;
		this.boolExpr = boolExpr;
	}

	public Expression<Boolean> createQueryData() {
		return createQueryData(null,boolExpr);
	}
	
	public Expression<Boolean> createQueryData(EntityManager em) {
		return createQueryData(em,boolExpr);
	}
	
	
	private Expression<Boolean> createQueryData(EntityManager em,BoolExpr e) {

		
		Expression<Boolean> exp=null;
		Expression<String> ps=null;
		Expression<Integer> intExp=null;
		Expression<Date> dateExp=null;
		Integer intParam=null;
		Date dateParam=null;
		Object operand0 = e.getOperand0();
		boolean caseInSensitive=false;
		if(e instanceof ExtBoolExpr){
			ExtBoolExpr ee=(ExtBoolExpr)e;
			if(ee.isCaseInSensitive()){
				caseInSensitive=true;
			}
		}
		if (operand0 != null) {
			if (operand0 instanceof BoolExpr) {
				Expression<Boolean>  tPqd = createQueryData(em,(BoolExpr) operand0);
				exp=tPqd;
			} else if (operand0 instanceof String) {
				String operand0Str=(String)operand0;
				
				if(caseInSensitive){
					//TODO
					//jpqlSelect="LOWER("+jpqlSelect+")";
				}
				
				exp=path.get(operand0Str);
				ps=path.get(operand0Str);
				intExp=path.get(operand0Str);
				dateExp=path.get(operand0Str);
			}
			Object operator = e.getOperator();
			if (operator == null) {
				//pqlWhere = "";
			} else {
				Object operand1=e.getOperand1();
				Object param=null;
				
				if( operand1 instanceof PersistenceObjectIdentifier){
					PersistenceObjectIdentifier poi=(PersistenceObjectIdentifier)operand1;
					param=em.find(poi.getTargetClass(), poi.getIdObject());
				}else{
					param=operand1;
				}
				String paramName=null;
				if(param!=null){
					if(param instanceof String && caseInSensitive){
				
					// problem with some locales see JSE API docs of java.lang.String.toLowerCase()
					// we cannot use the locale of the user because JPA will use the SQL-DB LOWER() function 
					// for the query results
					param=((String)param).toLowerCase(Locale.ENGLISH);
					}
					if(param instanceof Integer) {
						intParam=(Integer)param;
					}
					if(param instanceof Date) {
						dateParam=(Date)param;
					}
				}
				if (operator.equals(ExtBoolExpr.EQUAL_KEY)) {
					exp=cb.equal(exp, param);
				} else if (operator.equals(ExtBoolExpr.NOT_EQUAL_KEY)) {
					exp=cb.notEqual(exp, param);
				} else if (operator.equals(ExtBoolExpr.EQUAL)) {
					if(intExp!=null && intParam!=null) {
						exp=cb.equal(intExp,intParam);
					}else
						if(dateExp!=null && dateParam!=null) {
							exp=cb.equal(dateExp,dateParam);
						}else {
							exp=cb.equal(exp, param);
						}
				} else if (operator.equals(ExtBoolExpr.NOT_EQUAL)) {
					if(intExp!=null && intParam!=null) {
						exp=cb.notEqual(intExp,intParam);
					}else
						if(dateExp!=null && dateParam!=null) {
							exp=cb.notEqual(dateExp,dateParam);
						}else {
							exp=cb.notEqual(exp, param);
						}
				} else if (operator.equals(ExtBoolExpr.GREATER_THEN)) {
					if(intExp!=null && intParam!=null) {
						exp=cb.greaterThan(intExp,intParam);
					}else
						if(dateExp!=null && dateParam!=null) {
							exp=cb.greaterThan(dateExp,dateParam);
						}
				} else if (operator.equals(ExtBoolExpr.LESS_THEN)) {
					if(intExp!=null && intParam!=null) {
						exp=cb.lessThan(intExp,intParam);
					}else if(dateExp!=null && dateParam!=null) {
						exp=cb.lessThan(dateExp,dateParam);
					}
				}else if (operator.equals(ExtBoolExpr.STARTS_WITH)) {
					String likePattern=param + "%";
					exp=cb.like(ps,likePattern);
				} else if (operator.equals(ExtBoolExpr.ENDS_WITH)) {
					String likePattern="%" + param;
					exp=cb.like(ps,likePattern);
				} else if (operator.equals(ExtBoolExpr.CONTAINS)) {
					String likePattern="%" + param + "%";
					exp=cb.like(ps,likePattern);
				} else if (operator.equals(ExtBoolExpr.MEMBER)) {
					throw new IllegalArgumentException("Operator "+ExtBoolExpr.MEMBER+" not implemented yet.");
				} else if (operator.equals(ExtBoolExpr.EQUALS)) {
					exp=cb.equal(exp, param);
				} else if (operator.equals(ExtBoolExpr.NOT_MEMBER)) {
					throw new IllegalArgumentException("Operator "+ExtBoolExpr.NOT_MEMBER+" not implemented yet.");
				}  else if (operator.equals(ExtBoolExpr.EQUALS_NOT)) {
					throw new IllegalArgumentException("Operator "+ExtBoolExpr.EQUALS_NOT+" not implemented yet.");
				}  else if (operator.equals(ExtBoolExpr.BOUND)) {
					throw new IllegalArgumentException("Operator "+ExtBoolExpr.BOUND+" not implemented yet.");
				}  else if (operator.equals(ExtBoolExpr.NOT_BOUND)) {
					throw new IllegalArgumentException("Operator "+ExtBoolExpr.NOT_BOUND+" not implemented yet.");
				}else if (operator.equals(ExtBoolExpr.AND)) {
					if(param instanceof BoolExpr) {
						Expression<Boolean> tPqd = createQueryData(em,((BoolExpr) param));
						exp=cb.and(exp, tPqd);
					}
				} else if (operator.equals(ExtBoolExpr.OR)) {
					if(param instanceof BoolExpr) {
						Expression<Boolean> tPqd = createQueryData(em,((BoolExpr) param));
						exp=cb.or(exp, tPqd);
					}
				}else {
					throw new IllegalArgumentException("Unkown operator \""+operator+"\".");
				}

				//				if (param instanceof BoolExpr) {
				//					Expression<Boolean> tPqd = createQueryData(em,((BoolExpr) param));
				////					pqlWhere = pqlWhere.concat("( "
				////							+ tPqd.getConditionalExpression() + " )");
				////					
				//				} else {
				//					if (!valueSet) {
				////						vars.add(param);
				////						paramName=JPQL_PARAM_NAME_PREFIX+"_"+(vars.size()+paramCountOffset);
				////						pqlWhere = pqlWhere.concat(" :"+paramName+" ");
				////						
				//					}
				//
				//				}
			}
		}
		//return new PersistenceBoolExpr(pqlWhere, vars.toArray());
		return exp;
	}



}
