package ipsk.webapps;

import javax.persistence.EntityManager;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ipsk.jsp.Controller;
import ipsk.persistence.SecurityManager;

public abstract class BasicController implements Controller{

	protected boolean checkSecureRequestToken=false;
	
	public void setCheckSecureRequestToken(boolean checkSecureRequestToken) {
		this.checkSecureRequestToken = checkSecureRequestToken;
	}
	
	// key for command
	public final static String KEY_CMD = "_cmd";
	public final static String KEY_ACTION = "_action";
	public String getKEY_ACTION() {
		return KEY_ACTION;
	}
	public final static String KEY_QUERY_NAME="name";
	public static final String KEY_LOCALE = "_locale";

	protected SecurityManager securityManager=new SecurityManager();

	protected HttpServletRequest currentRequest;
	protected ProcessResult processResult;

	public static String RESOURCE_BUNDLE_NAME="ipsk.jsp.Messages";
	

	public BasicController() {
		super();
	}
	
	public String processCommand(HttpServletRequest request,String[] submitCommands ){
		String command = request.getParameter(KEY_CMD);
		
		// find submit commands
		for (String possibleSubmitCmd : submitCommands) {
			if (request.getParameter("_" + possibleSubmitCmd) != null) {
				command = possibleSubmitCmd;
				break;
			}
		}
		return command;
	}
	
	/**
	 * Compatibility method implementation only.
	 * @throws ControllerException 
	 */
	public ProcessResult process(HttpServletRequest request,HttpServletResponse response,Servlet servlet) throws ControllerException{
		processRequest(request);
		return getProcessResult();
	}

	/**
	 * Compatibility method implementation only.
	 * @throws ControllerException 
	 */
	public ProcessResult process(HttpServletRequest request,HttpServletResponse response) throws ControllerException{
		processRequest(request);
		return getProcessResult();
	}

	protected void clear(){
		processResult=null;
	}

	public ProcessResult getProcessResult() {
		return processResult;
	}

	public SecurityManager getSecurityManager() {
		return securityManager;
	}

	public void setSecurityManager(SecurityManager securityManager) {
		this.securityManager = securityManager;
	}

}
