package ipsk.webapps;

public class SelectMode {
	
	public enum ActionType {
		SET,RESET,ADD,REMOVE,CHANGE_SELECTION, DELETE;
		
		 public boolean isMultiSelection() {
		        switch(this) {
		            case ADD:  return true;
		            case REMOVE:  return true;
		            case DELETE:  return true;
		            default: return false;
		        }
		    }
	}
	
	private ActionType actionType=null;
	/**
	 * The property name of the bean for which the bean requests a selection.
	 */
	private String targetProperty;
	private String action;
	private boolean multiSelection=false;
	public SelectMode(ActionType actionType,String action,String targetProperty){
		this(actionType.isMultiSelection(),actionType,action,targetProperty);
	}
	public SelectMode(boolean multiSelection,ActionType actionType,String action,String targetProperty){
		super();
		this.multiSelection=multiSelection;
		this.actionType=actionType;
		this.action=action;
		this.targetProperty=targetProperty;
	}
	public ActionType getActionType() {
		return actionType;
	}
	
	public boolean isMultiSelection() {
		return multiSelection;
	}
	public String getAction() {
		return action;
	}
	public String getTargetProperty() {
		return targetProperty;
	}
	
}
