package ipsk.jsp.taglib;

import javax.servlet.jsp.JspException;

import ips.beans.BeanInfoProvider;
import ips.beans.ExtBeanInfo;
import ipsk.jsp.BeanTableController;
import ipsk.jsp.Controller;




public class ControllerProviderTag extends ExtBodyTagSupport implements BeanInfoProvider,ControllerProvider{
	protected  Controller controller;
	protected ipsk.persistence.Controller pctrl=null;

	protected boolean checkSecureRequestToken=false;

	public boolean getCheckSecureRequestToken() {
		return checkSecureRequestToken;
	}

	public void setCheckSecureRequestToken(boolean checkSecureToken) {
		this.checkSecureRequestToken = checkSecureToken;
	}
	
	protected Integer batchSize=null; // default unset
	
	public int doStartTag() throws JspException {
		return EVAL_BODY_INCLUDE;
	}

	public int doEndTag() throws JspException {
		
		return EVAL_PAGE;
	}

	public Controller getController() {
		return controller;
	}

	public void setController(Controller controller) {
		this.controller = controller;
		if(controller instanceof ipsk.persistence.Controller) {
			pctrl=(ipsk.persistence.Controller)controller;
		}else {
			pctrl=null;
		}
		
		this.controller.setCheckSecureRequestToken(checkSecureRequestToken);
		if(batchSize!=null){
			setBatchSize(batchSize);
		}
	}

	public ExtBeanInfo getBeanInfo() {
		if(controller instanceof BeanInfoProvider){
		return ((BeanInfoProvider)controller).getBeanInfo();
		}else{
			return null;
		}
	}

	public int getBatchSize() {
		return batchSize;
	}

	public void setBatchSize(int batchSize) {
		this.batchSize = batchSize;
		if(controller!=null && this.controller instanceof BeanTableController){
			((BeanTableController)this.controller).setBatchSize(batchSize);
		}
	}
}
