package ipsk.jsp.taglib.beans.table;

import ips.beans.ExtBeanInfo;
import ipsk.beans.PropertyNameOrder;
import ipsk.jsp.BeanTableController;
import ipsk.jsp.Controller;
import ipsk.jsp.taglib.ControllerProvider;
import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.beans.BeanControllerProvider;
import ipsk.sql.OrderBy;
import ipsk.sql.OrderByClause;
import ipsk.text.html.HTMLTextEncoder;
import ipsk.webapps.BasicPersistenceBeanController;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.Tag;

@SuppressWarnings("serial")
public class OrderByTag extends ExtBodyTagSupport {

	private ArrayList<PropertyDescriptor> displayedProps;
	
	private String CSSclass=null;
	private BeanTableController controller;
	public void setParent(Tag parent){
		if (parent instanceof ControllerProvider){
			Controller scontroller=((ControllerProvider)parent).getController();
			if(scontroller instanceof BeanTableController){
				controller=(BeanTableController)scontroller;
			}
			
			// TODO repeated code in BoolExprTag
			ExtBeanInfo beanInfo = controller.getBeanInfo();
			PropertyDescriptor[] pds = beanInfo
			.getPersistencePropertyDescriptors();
			displayedProps = new ArrayList<PropertyDescriptor>();
			ArrayList<String> displayablePropNames=new ArrayList<String>();
			for (PropertyDescriptor pd : pds) {
				Class type = pd.getPropertyType();
				// String typeName = type.getCanonicalName();

				if (type.isPrimitive() 
						// TODO Oracle TopLink Ess. and EclipseLink 2.0.2 do not support 
						// ORDER BY for boolean types
						// https://bugs.eclipse.org/bugs/show_bug.cgi?id=219814
//						|| type.equals(java.lang.Boolean.class)
						|| type.isEnum()
						|| java.lang.Number.class.isAssignableFrom(type)
						|| type.equals(java.lang.String.class)
						|| type.equals(java.util.Date.class)) {
					//displayedProps.add(pd);
					displayablePropNames.add(pd.getName());
				}
			}
			PropertyNameOrder pnOrder=new PropertyNameOrder(displayablePropNames.toArray(new String[0]));

			pnOrder.applyPreferredOrder(beanInfo.getPreferredDisplayOrder());
			String[] orderedPropNames=pnOrder.getOrder();
			for(String pName:orderedPropNames){
				for (PropertyDescriptor pd : pds) {
					if(pName.equals(pd.getName())){
						displayedProps.add(pd);
					}
				}
			}
		}
	}
	
	public int doStartTag() throws JspException {
		return EVAL_BODY_INCLUDE;
	}
	public int doEndTag() throws JspException {
		if (controller.getNamedQuery()==null){
		JspWriter ow = pageContext.getOut();
		
		OrderByClause orderByClause=controller.getOrderByClause();
		
//		String cssClassAttr="";
//		if(CSSclass!=null)cssClassAttr=" class=\""+CSSclass+"\"";
		
	
		 HttpServletRequest req=(HttpServletRequest)(pageContext.getRequest());
			//String contextPath=req.getContextPath();
			String servletPath=req.getServletPath();
			String encodedPath=encodeURL(servletPath);
		
		try {
			ow.println("<form method=\"POST\" action=\""+HTMLTextEncoder.encode(encodedPath)+"\" accept-charset=\"UTF-8\" enctype=\"application/x-www-form-urlencoded;charset=utf-8\">");
			ow.println("<fieldset>");
			ow.print("<legend>");
			ow.print(HTMLTextEncoder.encode(getLocalizedMessage("sort")));
			ow.println("</legend>");
			
			if (orderByClause==null || (orderByClause.getOrder().length==0)){
				ow.println("<select name=\"_ob0\">");
				ow.println("<option value=\"\" selected >-- "+getLocalizedMessage("field.select")+" --</option>");
				for (PropertyDescriptor pd : displayedProps) {	
					String pDescr=pd.getShortDescription();
					String resKey=(String)pd.getValue("ipsk.util.ResourceKey");
					if(resKey!=null){
					pDescr=LocaleSupport.getLocalizedMessage(pageContext, resKey,controller.getBeanInfo().getResourceBundleName());
					}
					ow.println("<option value=\""+pd.getName()+"\">"+HTMLTextEncoder.encode(pDescr)+"</option>");	
				}
				ow.println("</select>");
				
				ow.println("<select name=\"_obd0\">");
				ow.println("<option value=\"asc\" selected>"+getLocalizedMessage("ascending")+"</option>");
				ow.println("<option value=\"desc\">"+getLocalizedMessage("descending")+"</option>");	
				ow.println("</select>");		
				
			}else{
				OrderBy[] obs=orderByClause.getOrder();
				for(int i=0;i<obs.length;i++){
					OrderBy ob=obs[i];
					ow.println("<select name=\"_ob"+i+"\">");
					ow.println("<option value=\"\">-- "+getLocalizedMessage("reset")+" --</option>");
					for (PropertyDescriptor pd : displayedProps) {
						String pDescr=pd.getShortDescription();
						String resKey=(String)pd.getValue("ipsk.util.ResourceKey");
						if(resKey!=null){
						pDescr=LocaleSupport.getLocalizedMessage(pageContext, resKey,controller.getBeanInfo().getResourceBundleName());
						}
						String selected="";
						if(ob.getColumn().equals(pd.getName()))selected=" selected ";
						ow.println("<option value=\""+pd.getName()+"\""+selected+">"+HTMLTextEncoder.encode(pDescr)+"</option>");	
					}
					ow.println("</select>");
					ow.println("<select name=\"_obd"+i+"\">");
					
					if(ob.isDescending()){
						ow.println("<option value=\"asc\">"+getLocalizedMessage("ascending")+"</option>");
						ow.println("<option value=\"desc\" selected>"+getLocalizedMessage("descending")+"</option>");
					}else{
						ow.println("<option value=\"asc\" selected>"+getLocalizedMessage("ascending")+"</option>");
						ow.println("<option value=\"desc\">"+getLocalizedMessage("descending")+"</option>");
					}
					ow.println("</select>");		
				}	
			}
			ow.println("<input type=\"hidden\" name=\""+BasicPersistenceBeanController.KEY_CMD+"\" value=\""+BasicPersistenceBeanController.CMD_LIST_ORDER_BY+"\" />");
			ow.println("<input type=\"submit\" name=\"_submit\" value=\""+getLocalizedMessage("sort")+"\" />");
			ow.println("</fieldset>");
			ow.println("</form>");
	
		} catch (IOException ioe) {
			throw new JspException("Error: IOException while writing to client");
		}
		
		}
		return EVAL_PAGE;
	}


	public String getCSSclass() {
		return CSSclass;
	}

	public void setCSSclass(String sclass) {
		CSSclass = sclass;
	}

	
}
