package ipsk.jsp.taglib.beans;

import java.io.IOException;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.SecureRequestTokenProvider;

public class BeanPropertySecureTokenTag extends TagSupport {

	private static final long serialVersionUID = -8255938319139512579L;

	public static String secureRequestTokenInputElement(HttpServletRequest req) {
		String secTok=SecureRequestTokenProvider.generateSecureRequestToken(req);
		return "<input type=\"hidden\" name=\""+SecureRequestTokenProvider.SECURE_REQUEST_TOKEN_NAME+"\" value=\""+secTok+"\"/>";
	}
	
	public int doStartTag() throws JspException {
		super.doStartTag();
		
		JspWriter w = pageContext.getOut();
		
		ServletRequest sReq=pageContext.getRequest();
		if(sReq instanceof HttpServletRequest) {
			HttpServletRequest req=(HttpServletRequest)sReq;
			try {
				String ie=secureRequestTokenInputElement(req);
				w.println(ie);
			}catch(IOException ioe) {
				throw new JspException(ioe);
			}
		}
		return SKIP_BODY;
	}
	

	public int doEndTag() throws JspException {
		return EVAL_PAGE;
	}

}
