package ipsk.webapps;

import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ipsk.jsp.Controller;

public abstract class BasicPersistenceJSPController extends BasicController implements Controller{

	protected ServletContext servletContext;
	protected HttpServletRequest currentRequest;
	protected ProcessResult processResult=new ProcessResult(ProcessResult.Type.SUCCESS);
	
	public BasicPersistenceJSPController(String persistenceUnit) {
		super();
	}

	@Override
	public ProcessResult process(HttpServletRequest request, HttpServletResponse response) throws ControllerException{
		this.currentRequest=request;
		return processResult;
	}

	@Override
	public ProcessResult process(HttpServletRequest request, HttpServletResponse response, Servlet servlet)
			throws ControllerException {
		this.currentRequest=request;
		return processResult;
	}

	@Override
	public void setServletContext(ServletContext servletContext) {
		this.servletContext=servletContext;	
	}

	@Override
	public void processRequest(HttpServletRequest req) throws ControllerException{
		this.currentRequest=req;
	}

	@Override
	public ProcessResult getProcessResult() {
		return processResult;
	}

}
